% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENAplot.R
\docType{class}
\name{ENAplot}
\alias{ENAplot}
\title{ENAplot Class}
\description{
The ENAplot R6 class provides a structure for visualizing ENAset objects using plotly.
It encapsulates the ENAset data, the plotly visualization, and related plotting parameters.
}
\section{Fields}{

\describe{
  \item{enaset}{The \code{\link{ENAset}} object from which the ENAplot was constructed.}
  \item{plot}{The plotly object used for data visualization.}
  \item{axes}{Axes information for the plot (TBD).}
  \item{point}{Point information for the plot (TBD).}
  \item{palette}{Color palette used for plotting (TBD).}
  \item{plotted}{Indicates whether the plot has been rendered (TBD).}
}
}

\examples{
# Example usage:
# enaplot <- ENAplot$new(enaset = myENAset)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{enaset}}{- The \code{\link{ENAset}} object from which the ENAplot was constructed}

\item{\code{plot}}{- The plotly object used for data visualization}

\item{\code{axes}}{A list or object specifying the axes configuration for the ENA plot, such as axis labels, limits, or scaling.}

\item{\code{point}}{A structure representing the data points to be plotted, including coordinates and visual properties.}

\item{\code{palette}}{A set of colors or a function defining the color scheme used for plotting elements in the ENA plot.}

\item{\code{plotted}}{A logical or status indicator showing whether the plot has been rendered or updated.}

\item{\code{showticklabels}}{Logical. Indicates whether to show tick labels on the axes.}

\item{\code{autosize}}{Logical. Indicates whether the plot should automatically resize.}

\item{\code{automargin}}{Logical. Indicates whether the plot should automatically adjust margins.}

\item{\code{axispadding}}{Numeric. Padding factor for the axes.
Create ENApolot}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ENAplot-new}{\code{ENAplot$new()}}
\item \href{#method-ENAplot-print}{\code{ENAplot$print()}}
\item \href{#method-ENAplot-get}{\code{ENAplot$get()}}
\item \href{#method-ENAplot-clone}{\code{ENAplot$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ENAplot-new"></a>}}
\if{latex}{\out{\hypertarget{method-ENAplot-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ENAplot$new(
  enaset = NULL,
  title = "ENA Plot",
  dimension.labels = c("", ""),
  font.size = 14,
  font.color = "#000000",
  font.family = "Arial",
  scale.to = "network",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{enaset}}{An ENA set object containing the data to be plotted.}

\item{\code{title}}{The title of the plot.}

\item{\code{dimension.labels}}{Labels for the dimensions shown in the plot.}

\item{\code{font.size}}{Numeric value specifying the font size for plot text.}

\item{\code{font.color}}{Color value for the plot text.}

\item{\code{font.family}}{Font family to use for plot text.}

\item{\code{scale.to}}{Numeric value to scale the plot axes.}

\item{\code{...}}{Additional arguments passed to the plotting function.      #'}

\item{\code{showticklabels}}{Logical; whether to display axis tick labels.}

\item{\code{autosize}}{Logical; whether the plot should automatically size itself.}

\item{\code{automargin}}{Logical; whether the plot should automatically adjust margins.}

\item{\code{axispadding}}{Numeric value specifying padding around axes.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ENAplot
Print ENA plot
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ENAplot-print"></a>}}
\if{latex}{\out{\hypertarget{method-ENAplot-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ENAplot$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Get property from object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ENAplot-get"></a>}}
\if{latex}{\out{\hypertarget{method-ENAplot-get}{}}}
\subsection{Method \code{get()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ENAplot$get(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{character key to retrieve from object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
value from object at x
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ENAplot-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ENAplot-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ENAplot$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
