% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{find_non_empty_bins}
\alias{find_non_empty_bins}
\title{Find the number of bins required to achieve required number of non-empty bins.}
\usage{
find_non_empty_bins(nldr_scaled_obj, m = 2, q = 0.1)
}
\arguments{
\item{nldr_scaled_obj}{A list of a tibble contains scaled first and second columns
of NLDR data, and numeric vectors representing the limits of the original NLDR data.}

\item{m}{The desired number of non-empty bins.}

\item{q}{The buffer amount as proportion of data range.}
}
\value{
The number of bins along the x and y axes
needed to achieve a specific number of non-empty bins.
}
\description{
This function determines the number of bins along the x and y axes
to obtain a specific number of non-empty bins.
}
\examples{
find_non_empty_bins(nldr_scaled_obj = scurve_model_obj$nldr_scaled_obj, m = 5)

}
