% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{augment.highd_vis_model}
\alias{augment.highd_vis_model}
\title{Augment Data with Predictions and Error Metrics for NLDR Models}
\usage{
\method{augment}{highd_vis_model}(x, highd_data, ...)
}
\arguments{
\item{x}{An object of class \code{highd_vis_model} containing the model outputs.}

\item{highd_data}{A data frame or tibble containing the original high-dimensional coordinates with an \code{ID} column.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A tibble containing the augmented data with predictions,
error metrics, and absolute error metrics.
}
\description{
This S3 method augments a dataset with predictions and error metrics obtained
from a nonlinear dimension reduction (NLDR) model stored in a \code{highd_vis_model} object.
}
\examples{
# Assuming 'fit' is a highd_vis_model object and 'scurve' contains the original data:
fit <- fit_highd_model(highd_data = scurve, nldr_data = scurve_umap, b1 = 30,
q = 0.1, hd_thresh = 5)
augment(x = fit, highd_data = scurve)


}
