% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{prop_test}
\alias{prop_test}
\title{Test for Sample Proportion Against Pi (chi-square test of goodness of fit)}
\usage{
prop_test(
  x,
  pi = 0.5,
  yates = TRUE,
  ci.level = 0.95,
  rtn.table = TRUE,
  check = TRUE
)
}
\arguments{
\item{x}{numeric vector that only has values of 0 or 1 (or missing values),
otherwise known as a dummy variable.}

\item{pi}{numeric vector of length 1 specifying the population proportion
value to compare the sample proportion against.}

\item{yates}{logical vector of length 1 specifying whether the Yate's
continuity correction should be applied for small samples. See
\code{\link[stats]{chisq.test}} for details.}

\item{ci.level}{numeric vector of length 1 specifying the confidence level.
\code{ci.level} must range from 0 to 1.}

\item{rtn.table}{logical vector of lengh 1 specifying whether the return
object should include the 1x2 contingency table of counts with totals and
the 1x2 overall percentages table. If TRUE, then the last two elements of
the return object are "count" containing a vector of counts and "percent"
containing a vector of overall percentages.}

\item{check}{logical vector of length 1 specifying whether the input
arguments should be checked for errors. For example, if \code{x} is a dummy
variable that only takes on value of 0 or 1 (or missing values). This is a
tradeoff between computational efficiency (FALSE) and more useful error
messages (TRUE).}
}
\value{
list of numeric vectors containing statistical information about the
  proportion difference from pi: 1) nhst = chi-square test of goodness of fit stat
  info in a numeric vector, 2) desc = descriptive statistics stat info in a
  numeric vector, 3) std = various standardized effect sizes in a numeric vector,
  4) count = numeric vector of length 3 with table of counts with an additional
  element for the total (if \code{rtn.table} = TRUE), 5) percent = numeric vector
  of length 3 with table of overall percentages with an element for the total
  (if \code{rtn.table} = TRUE)

1) nhst = chi-square test of goodness of fit stat info in a numeric vector

\describe{
   \item{est}{proportion difference estimate (i.e., sample proportion - pi)}
   \item{se}{NA (to remind the user there is no standard error for the test)}
   \item{X2}{chi-square value}
   \item{df}{degrees of freedom (will always be 1)}
   \item{p}{two-sided p-value}
}

2) desc = descriptive statistics stat info in a numeric vector

\describe{
   \item{prop}{sample proportion}
   \item{pi}{popularion proportion provided by the user (or 0.50 by default)}
   \item{sd}{standard deviation}
   \item{n}{sample size}
   \item{lwr}{lower bound of the confidence interval of the sample proportion itself}
   \item{upr}{upper bound of the confidence interval of the sample proportion itself}
}

3) std = various standardized effect sizes in a numeric vector

\describe{
   \item{cramer}{Cramer's V estimate}
   \item{h}{Cohen's h estimate}
}

4) count = numeric vector of length 3 with table of counts with an additional
element for the total (if \code{rtn.table} = TRUE). The names are 1. "0", 2.
"1", 3. "total"

5) percent = numeric vector of length 3 with table of overall percentages with
an element for the total (if \code{rtn.table} = TRUE). The names are 1. "0", 2.
"1", 3. "total"
}
\description{
\code{prop_test} tests for a sample proportion difference from a population
proportion with a chi-square test of goodness of fit. The default is that the
goodness of fit is consistent with a population proportion Pi of 0.50. The
function also calculates the descriptive statistics, various standardized
effect sizes (e.g., Cramer's V), and can provide the 1x2 contingency tables.
\code{prop_test} is simply a wrapper for \code{\link[stats]{prop.test}} plus
some extra calculations.
}
\examples{

# chi-square test of goodness of fit
table(mtcars$"am")
prop_test(mtcars$"am")
prop_test(ifelse(mtcars$"am" == 1, yes = 0, no = 1))

# different than intercept only logistic regression
summary(glm(am ~ 1, data = mtcars, family = binomial(link = "logit")))

# error from non-dummy variable
\dontrun{
prop_test(ifelse(mtcars$"am" == 1, yes = "1", no = "0"))
prop_test(ifelse(mtcars$"am" == 1, yes = 2, no = 1))
}

}
\seealso{
\code{\link[stats]{prop.test}} the workhorse for \code{prop_test},
   \code{\link{props_test}} for multiple dummy variables,
   \code{\link{prop_diff}} for chi-square test of independence,
}
