% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domains.R
\name{with_promise_domain}
\alias{with_promise_domain}
\alias{new_promise_domain}
\title{Promise domains}
\usage{
with_promise_domain(domain, expr, replace = FALSE)

new_promise_domain(
  wrapOnFulfilled = identity,
  wrapOnRejected = identity,
  wrapSync = force,
  onError = force,
  ...,
  wrapOnFinally = NULL
)
}
\arguments{
\item{domain}{A promise domain object to install while \code{expr} is evaluated.}

\item{expr}{Any R expression, to be evaluated under the influence of
\code{domain}.}

\item{replace}{If \code{FALSE}, then the effect of the \code{domain} will be added
to the effect of any currently active promise domain(s). If \code{TRUE}, then
the current promise domain(s) will be ignored for the duration of the
\code{with_promise_domain} call.}

\item{wrapOnFulfilled}{A function that takes a single argument: a function
that was passed as an \code{onFulfilled} argument to \code{\link[=then]{then()}}. The
\code{wrapOnFulfilled} function should return a function that is suitable for
\code{onFulfilled} duty.}

\item{wrapOnRejected}{A function that takes a single argument: a function
that was passed as an \code{onRejected} argument to \code{\link[=then]{then()}}. The
\code{wrapOnRejected} function should return a function that is suitable for
\code{onRejected} duty.}

\item{wrapSync}{A function that takes a single argument: a (lazily evaluated)
expression that the function should \code{\link[=force]{force()}}. This expression represents
the \code{expr} argument passed to \code{\link[=with_promise_domain]{with_promise_domain()}};
\code{wrapSync} allows the domain to manipulate the environment before/after
\code{expr} is evaluated.}

\item{onError}{A function that takes a single argument: an error. \code{onError}
will be called whenever an exception occurs in a domain (that isn't caught
by a \code{tryCatch}). Providing an \code{onError} callback doesn't cause errors to
be caught, necessarily; instead, \code{onError} callbacks behave like calling
handlers.}

\item{...}{Arbitrary named values that will become elements of the promise
domain object, and can be accessed as items in an environment (i.e. using
\code{[[} or \code{$}).}

\item{wrapOnFinally}{A function that takes a single argument: a function
that was passed as an \code{onFinally} argument to \code{\link[=then]{then()}}. The
\code{wrapOnFinally} function should return a function that is suitable for
\code{onFinally} duty. If \code{wrapOnFinally} is \code{NULL} (the default), then the
domain will use both \code{wrapOnFulfilled} and \code{wrapOnRejected} to wrap the
\code{onFinally}. If it's important to distinguish between normal
fulfillment/rejection handlers and finally handlers, then be sure to
provide \code{wrapOnFinally}, even if it's just \code{\link[base:identity]{base::identity()}}.}
}
\description{
Promise domains are used to temporarily set up custom environments that
intercept and influence the registration of callbacks. Create new promise
domain objects using \code{new_promise_domain}, and temporarily activate a promise
domain object (for the duration of evaluating a given expression) using
\code{with_promise_domain}.
}
\details{
While \code{with_promise_domain} is on the call stack, any calls to
\code{\link[=then]{then()}} (or higher level functions or operators, like
\code{\link[=catch]{catch()}}) will belong to the promise domain. In addition, when a
\code{then} callback that belongs to a promise domain is invoked, then any new
calls to \code{then} will also belong to that promise domain. In other words, a
promise domain "infects" not only the immediate calls to \code{then}, but also to
"nested" calls to \code{then}.

For more background, read the
\href{https://gist.github.com/jcheng5/b1c87bb416f6153643cd0470ac756231}{original design doc}.

For examples, see the source code of the Shiny package, which uses promise
domains extensively to manage graphics devices and reactivity.
}
