% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signedrank.R
\name{signedrank}
\alias{signedrank}
\title{Power calculation for signed-rank test}
\usage{
signedrank(
  N = NULL,
  ps = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size; number of observations or paired differences.}

\item{ps}{The probability that the sum of two values exceeds zero when the alternative hypothesis is true.}

\item{alpha}{The significance level or type 1 error rate; defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two-sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
The signed-rank test is a nonparametric alternative to a one-sample or paired t test. This function
performs power and sample size calculations for the signed-rank test using Noether's approximation;
see Noether (1987) Sample size determination for some common nonparametric tests. JASA 82(398):645-647.
}
\details{
Due to symmetry, the power for p is equal to the power for 1 - p. Therefore,
when solving for p, two values, p and 1 - p, are returned.
}
\examples{
signedrank(N = 20, ps = 0.87, power = NULL, sides = 2)
}
