% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venndiagram.R
\name{prepare_venn_data}
\alias{prepare_venn_data}
\title{Prepare data for Venn diagram}
\usage{
prepare_venn_data(
  data,
  in_form = "auto",
  group_by = NULL,
  group_by_sep = "_",
  id_by = NULL
)
}
\arguments{
\item{data}{A data frame or a list or a VennPlotData object.}

\item{in_form}{A character string indicating the datatype of the input data.
Possible values are "long", "wide", "list", "venn" or NULL.
"long" indicates the data is in long format.
"wide" indicates the data is in wide format.
"list" indicates the data is a list.
"venn" indicates the data is a VennPlotData object.
"auto" indicates the function will detect the datatype of the input data.

A long format data would look like:
\preformatted{
group_by id_by
A        a1
A        a2
B        a1
B        a3
...
}

A wide format data would look like:
\preformatted{
A    B
TRUE TRUE
TRUE FALSE
FALSE TRUE
...
}

A list format data would look like:
\preformatted{
list(A = c("a1", "a2"), B = c("a1", "a3"))
}}

\item{group_by}{A character string specifying the column name of the data frame to group the data.}

\item{group_by_sep}{A character string to concatenate the columns in \code{group_by},
if multiple columns are provided and the in_form is "long".}

\item{id_by}{A character string specifying the column name of the data frame to identify the instances.
Required when \code{group_by} is a single column and data is a data frame.}
}
\value{
A VennPlotData object
}
\description{
Prepare data for Venn diagram
}
\keyword{internal}
