# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate differences between characters in columns of germs and return them as a string vector.
#'
#' @param germs A vector of strings representing germ sequences.
#' @param X The threshold index from which to return differences as strings.
#' @param non_mismatch_chars_nullable A set of characters that are ignored when comparing sequences (default: 'N', '.', '-').
#' @return A vector of strings containing differences between characters in columns.
#'
#' @examples
#' germs = c("ATCG", "ATCC") 
#' X = 3 
#' result = allele_diff_strings(germs, X) 
#' # "A2T", "T3C", "C2G"
#' @name allele_diff_strings
#' @export
allele_diff_strings <- function(germs, X = 0L, non_mismatch_chars_nullable = NULL) {
    .Call(`_piglet_allele_diff_strings`, germs, X, non_mismatch_chars_nullable)
}

#' Calculate differences between characters in columns of germs and return their indices as an int vector.
#'
#' @param germs A vector of strings representing germ sequences.
#' @param X The threshold index from which to return differences as indices.
#' @param non_mismatch_chars_nullable A set of characters that are ignored when comparing sequences (default: 'N', '.', '-').
#' @return A vector of integers containing indices of differing columns.
#'
#' @examples 
#' germs = c("ATCG", "ATCC") 
#' X = 3 
#' result = allele_diff_indices(germs, X)
#' # 1, 2, 3
#' @name allele_diff_indices
#' @export
allele_diff_indices <- function(germs, X = 0L, non_mismatch_chars_nullable = NULL) {
    .Call(`_piglet_allele_diff_indices`, germs, X, non_mismatch_chars_nullable)
}

#' Calculate SNPs or their count for each germline-input sequence pair with optional parallel execution.
#'
#' @param germs A vector of strings representing germline sequences.
#' @param inputs A vector of strings representing input sequences.
#' @param X The threshold index from which to return SNP indices or counts (default: 0).
#' @param parallel A boolean flag to enable parallel processing (default: FALSE).
#' @param return_count A boolean flag to return the count of mutations instead of their indices (default: FALSE).
#' @return A list of integer vectors (if return_count = FALSE) or a vector of integers (if return_count = TRUE).
#' 
#' @name allele_diff_indices_parallel
#' @export
allele_diff_indices_parallel <- function(germs, inputs, X = 0L, parallel = FALSE, return_count = FALSE) {
    .Call(`_piglet_allele_diff_indices_parallel`, germs, inputs, X, parallel, return_count)
}

#' Calculate SNPs or their count for each germline-input sequence pair with optional parallel execution.
#'
#' This function compares germline sequences (`germs`) and input sequences (`inputs`)
#' and identifies single nucleotide polymorphisms (SNPs) or their counts, with optional parallel execution.
#' The comparison ignores specified non-mismatch characters (e.g., gaps or ambiguous bases).
#'
#' @param germs A vector of strings representing germline sequences.
#' @param inputs A vector of strings representing input sequences.
#' @param X The threshold index from which to return SNP indices or counts (default: 0).
#' @param parallel A boolean flag to enable parallel processing (default: FALSE).
#' @param return_count A boolean flag to return the count of mutations instead of their indices (default: FALSE).
#' @param non_mismatch_chars_nullable A set of characters that are ignored when comparing sequences (default: 'N', '.', '-').
#' @return A list of integer vectors (if `return_count = FALSE`) or a vector of integers (if `return_count = TRUE`).
#'
#' @examples
#' # Example usage
#' germs <- c("ATCG", "ATCC")
#' inputs <- c("ATTG", "ATTA")
#' X <- 0
#'
#' # Return indices of SNPs
#' result_indices <- allele_diff_indices_parallel2(germs, inputs, X, 
#' parallel = TRUE, return_count = FALSE)
#' print(result_indices)  # list(c(4), c(3, 4))
#'
#' # Return counts of SNPs
#' result_counts <- allele_diff_indices_parallel2(germs, inputs, X, 
#' parallel = FALSE, return_count = TRUE)
#' print(result_counts)  # c(1, 2)
#'
#' @name allele_diff_indices_parallel2
#' @export
allele_diff_indices_parallel2 <- function(germs, inputs, X = 0L, parallel = FALSE, return_count = FALSE, non_mismatch_chars_nullable = NULL) {
    .Call(`_piglet_allele_diff_indices_parallel2`, germs, inputs, X, parallel, return_count, non_mismatch_chars_nullable)
}

#' Insert gaps into an ungapped sequence based on a gapped reference sequence.
#'
#' This function inserts gaps (e.g., `.` or `-`) into an ungapped sequence (`ungapped`)
#' to match the positions of gaps in a reference sequence (`gapped`). It ensures that
#' the aligned sequence has the same gap structure as the reference.
#'
#' @param gapped A vector of strings representing the reference sequences with gaps.
#' @param ungapped A vector of strings representing the sequences without gaps.
#' @param parallel A boolean flag to enable parallel processing (default: FALSE).
#' @return A vector of strings with gaps inserted to match the gapped reference.
#'
#' @examples
#' # Example usage
#' gapped <- c("caggtc..aact", "caggtc---aact")
#' ungapped <- c("caggtcaact", "caggtcaact")
#'
#' # Sequential execution
#' result <- insert_gaps2_vec(gapped, ungapped, parallel = FALSE)
#' print(result)  # "caggtc..aact", "caggtc---aact"
#'
#' # Parallel execution
#' result_parallel <- insert_gaps2_vec(gapped, ungapped, parallel = TRUE)
#' print(result_parallel)
#'
#' @name insert_gaps2_vec
#' @export
insert_gaps2_vec <- function(gapped, ungapped, parallel = FALSE) {
    .Call(`_piglet_insert_gaps2_vec`, gapped, ungapped, parallel)
}

