% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_canape.R
\name{ps_canaper}
\alias{ps_canaper}
\title{Binary randomization tests including CANAPE}
\usage{
ps_canaper(ps, null_model = "curveball", spatial = TRUE, ...)
}
\arguments{
\item{ps}{phylospatial object}

\item{null_model}{see \code{?canaper::cpr_rand_test()}}

\item{spatial}{Logical: should the function return a spatial object (TRUE, default) or a vector (FALSE).}

\item{...}{further arguments passed to \code{canaper::cpr_rand_test()}}
}
\value{
A \code{matrix }or \code{SpatRaster}, or \code{sf} with a column or layer for each metric.
}
\description{
This function is a wrapper around \code{canaper::cpr_rand_test()}. It only works with binary community data.
It is largely redundant with \code{ps_rand()} and \code{ps_canape()}, which are more flexible in supporting data sets
with non-binary community data. However, this function runs faster, and supports custom null models via
\link[vegan]{make.commsim}.
}
\details{
This function runs \code{canaper::cpr_rand_test()}; see the help for that function for details.

It also runs \code{canaper::cpr_classify_endem()} on the result, and includes the resulting classification as an
additional variable, 'endem_type', in the output. 'endem_type' values 0-4 correspond to not-significant, neo,
paleo, mixed, and super endemisim, respectively.
}
\examples{
\donttest{
if(requireNamespace("canaper")){
      ps <- ps_simulate(data_type = "binary")
      terra::plot(ps_canaper(ps)$pd_obs_p_upper)
}
}
}
\references{
Mishler, B. D., Knerr, N., González-Orozco, C. E., Thornhill, A. H., Laffan, S. W., & Miller, J. T. (2014).
Phylogenetic measures of biodiversity and neo-and paleo-endemism in Australian Acacia. Nature Communications, 5(1), 4473.

Nitta, J. H., Laffan, S. W., Mishler, B. D., & Iwasaki, W. (2023). canaper: categorical analysis
of neo‐and paleo‐endemism in R. Ecography, 2023(9), e06638.
}
\seealso{
\code{\link[=ps_canape]{ps_canape()}}, \code{\link[=ps_rand]{ps_rand()}}
}
