% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phinterval.R
\name{phint_length}
\alias{phint_length}
\alias{phint_length.default}
\alias{phint_length.Interval}
\alias{phint_length.phinterval}
\alias{phint_lengths}
\alias{phint_lengths.default}
\alias{phint_lengths.Interval}
\alias{phint_lengths.phinterval}
\title{Compute the length of a phinterval in seconds}
\usage{
phint_length(phint)

\method{phint_length}{default}(phint)

\method{phint_length}{Interval}(phint)

\method{phint_length}{phinterval}(phint)

phint_lengths(phint)

\method{phint_lengths}{default}(phint)

\method{phint_lengths}{Interval}(phint)

\method{phint_lengths}{phinterval}(phint)
}
\arguments{
\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}
}
\value{
For \code{phint_length()}, a numeric vector the same length as \code{phint}.

For \code{phint_lengths()}, a list of numeric vectors the same length as \code{phint}.
}
\description{
\code{phint_length()} calculates the total length of all time spans within each
phinterval element in seconds. For phintervals with multiple disjoint spans,
the lengths are summed. Instantaneous intervals and holes have length 0.

\code{phint_lengths()} returns the individual length in seconds of each time span
within each phinterval element.
}
\examples{
monday <- interval(as.Date("2025-11-10"), as.Date("2025-11-11"))
friday <- interval(as.Date("2025-11-14"), as.Date("2025-11-15"))

phint_length(monday)
phint_length(phint_intersect(monday, friday))

# phint_length() sums the lengths of disjoint time spans
mon_and_fri <- phint_union(monday, friday)
phint_length(mon_and_fri) == phint_length(monday) + phint_length(friday)

# phint_lengths() returns the length of each disjoint time span
phint_lengths(mon_and_fri)

}
