% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_fuzzy_match.R
\name{fuzzy_match_species_within_genus}
\alias{fuzzy_match_species_within_genus}
\title{Fuzzy Match Species within Genus in Peru Mammals Database}
\usage{
fuzzy_match_species_within_genus(df, target_df = NULL)
}
\arguments{
\item{df}{A data frame containing species data to be matched.
Must include columns: Orig.Species, Matched.Genus}

\item{target_df}{A data frame representing peru_mammals database.
Must include columns: genus, species}
}
\value{
A tibble with additional columns:
\itemize{
\item \code{fuzzy_match_species_within_genus}: Logical indicating match success
\item \code{fuzzy_species_dist}: Numeric distance for each match
\item \code{Matched.Species}: The matched species name
}
}
\description{
Performs fuzzy matching of species names within a matched genus using
string distance to account for spelling variations. Peru mammals database
does not include infraspecific taxa.
}
\details{
This function processes each matched genus separately for efficiency.
If multiple species match with the same distance, a warning is issued
and the first match is selected. Use \code{get_ambiguous_matches(result, type = "species")}
to examine ambiguous cases.

Special handling for "sp." cases:
\itemize{
\item "Akodon sp. Ancash" is treated as a complete specific epithet
\item Fuzzy matching will work on the entire "SP. ANCASH" string
}
}
\keyword{internal}
