% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C5_rules_C5.0.R
\name{details_C5_rules_C5.0}
\alias{details_C5_rules_C5.0}
\title{C5.0 rule-based classification models}
\description{
\code{\link[C50:C5.0]{C50::C5.0()}} fits a model that derives feature rules from a tree for
prediction. A single tree or boosted ensemble can be used. \code{\link[rules:rules-internal]{rules::c5_fit()}}
is a wrapper around this function.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{trees}: # Trees (type: integer, default: 1L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 2L)
}

Note that C5.0 has a tool for \emph{early stopping} during boosting where
less iterations of boosting are performed than the number requested.
\code{C5_rules()} turns this feature off (although it can be re-enabled using
\code{\link[C50:C5.0Control]{C50::C5.0Control()}}).
}

\subsection{Translation from parsnip to the underlying model call (classification)}{

The \strong{rules} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(rules)

C5_rules(
  trees = integer(1),
  min_n = integer(1)
) |>
  set_engine("C5.0") |>
  set_mode("classification") |>
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## C5.0 Model Specification (classification)
## 
## Main Arguments:
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: C5.0 
## 
## Model fit template:
## rules::c5_fit(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     trials = integer(1), minCases = integer(1))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("C5_rules_predict") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 2 x 2
##   mode           type 
##   <chr>          <chr>
## 1 classification class
## 2 classification prob
}\if{html}{\out{</div>}}
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}

\subsection{References}{
\itemize{
\item Quinlan R (1992). “Learning with Continuous Classes.” Proceedings of
the 5th Australian Joint Conference On Artificial Intelligence,
pp. 343-348.
\item Quinlan R (1993).”Combining Instance-Based and Model-Based Learning.”
Proceedings of the Tenth International Conference on Machine Learning,
pp. 236-243.
\item Kuhn M and Johnson K (2013). \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
