% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_live.R
\name{openai_compare_pair_live}
\alias{openai_compare_pair_live}
\title{Live OpenAI comparison for a single pair of samples}
\usage{
openai_compare_pair_live(
  ID1,
  text1,
  ID2,
  text2,
  model,
  trait_name,
  trait_description,
  prompt_template = set_prompt_template(),
  endpoint = c("chat.completions", "responses"),
  tag_prefix = "<BETTER_SAMPLE>",
  tag_suffix = "</BETTER_SAMPLE>",
  api_key = NULL,
  include_raw = FALSE,
  ...
)
}
\arguments{
\item{ID1}{Character ID for the first sample.}

\item{text1}{Character string containing the first sample's text.}

\item{ID2}{Character ID for the second sample.}

\item{text2}{Character string containing the second sample's text.}

\item{model}{OpenAI model name (e.g. "gpt-4.1", "gpt-5.2-2025-12-11").}

\item{trait_name}{Short label for the trait (e.g. "Overall Quality").}

\item{trait_description}{Full-text definition of the trait.}

\item{prompt_template}{Prompt template string.}

\item{endpoint}{Which OpenAI endpoint to use: \code{"chat.completions"} or
\code{"responses"}.}

\item{tag_prefix}{Prefix for the better-sample tag.}

\item{tag_suffix}{Suffix for the better-sample tag.}

\item{api_key}{Optional OpenAI API key.}

\item{include_raw}{Logical; if TRUE, adds a \code{raw_response} column.}

\item{...}{Additional OpenAI parameters, for example
\code{temperature}, \code{top_p}, \code{logprobs}, \code{reasoning},
and (optionally) \code{include_thoughts}. The same validation rules for
gpt-5 models are applied as in \code{\link{build_openai_batch_requests}}.
When using the Responses endpoint with reasoning models, you can request
reasoning summaries in the \code{thoughts} column by setting
\code{endpoint = "responses"}, a non-"none" reasoning effort, and
\code{include_thoughts = TRUE}.}
}
\value{
A tibble with one row and columns:
\describe{
\item{custom_id}{ID string of the form \code{"LIVE_<ID1>_vs_<ID2>"}.}
\item{ID1, ID2}{The sample IDs you supplied.}
\item{model}{Model name reported by the API.}
\item{object_type}{OpenAI object type (for example "chat.completion" or
"response").}
\item{status_code}{HTTP-style status code (200 if successful).}
\item{error_message}{Error message if something goes wrong; otherwise NA.}
\item{thoughts}{Reasoning / thinking summary text when available,
otherwise NA.}
\item{content}{Concatenated text from the assistant's visible output. For
the Responses endpoint this is taken from the \code{type = "message"}
output items and does not include reasoning summaries.}
\item{better_sample}{"SAMPLE_1", "SAMPLE_2", or NA.}
\item{better_id}{ID1 if SAMPLE_1 is chosen, ID2 if SAMPLE_2 is chosen,
otherwise NA.}
\item{prompt_tokens}{Prompt / input token count (if reported).}
\item{completion_tokens}{Completion / output token count (if reported).}
\item{total_tokens}{Total token count (if reported).}
\item{raw_response}{(Optional) list-column containing the parsed JSON
body.}
}
}
\description{
This function sends a single pairwise comparison prompt to the OpenAI API
and parses the result into a small tibble. It is the live / on-demand
analogue of \code{\link{build_openai_batch_requests}} plus
\code{\link{parse_openai_batch_output}}.
}
\details{
It supports both the Chat Completions endpoint ("/v1/chat/completions") and
the Responses endpoint ("/v1/responses", for example gpt-5.1 with reasoning),
using the same prompt template and model / parameter rules as the batch
pipeline.

For the Responses endpoint, the function collects:
\itemize{
\item Reasoning / "thoughts" text (if available) into the \code{thoughts}
column.
\item Visible assistant output into the \code{content} column.
}

\strong{Temperature Defaults:}
If \code{temperature} is not provided in \code{...}:
\itemize{
\item It defaults to \code{0} (deterministic) for standard models or when reasoning is
disabled.
\item It remains \code{NULL} when reasoning is enabled, as the API does not support
temperature in that mode.
}
}
\examples{
\dontrun{
# Requires API key set and internet access

# 1. Standard comparison using GPT-4.1
res <- openai_compare_pair_live(
  ID1 = "A", text1 = "Text A...",
  ID2 = "B", text2 = "Text B...",
  model = "gpt-4.1",
  trait_name = "clarity",
  trait_description = "Which text is clearer?",
  temperature = 0
)

# 2. Reasoning comparison using GPT-5.2
res_reasoning <- openai_compare_pair_live(
  ID1 = "A", text1 = "Text A...",
  ID2 = "B", text2 = "Text B...",
  model = "gpt-5.2-2025-12-11",
  trait_name = "clarity",
  trait_description = "Which text is clearer?",
  endpoint = "responses",
  include_thoughts = TRUE,
  reasoning = "high"
)
print(res_reasoning$thoughts)
}

}
