% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{SearchResource}
\alias{SearchResource}
\title{Search Resource}
\value{
Search results with pagination.

A tibble of all matching concepts.

Search results with facets and metadata.

Autocomplete suggestions.
}
\description{
R6 class providing access to search operations.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SearchResource-new}{\code{SearchResource$new()}}
\item \href{#method-SearchResource-basic}{\code{SearchResource$basic()}}
\item \href{#method-SearchResource-basic_all}{\code{SearchResource$basic_all()}}
\item \href{#method-SearchResource-advanced}{\code{SearchResource$advanced()}}
\item \href{#method-SearchResource-autocomplete}{\code{SearchResource$autocomplete()}}
\item \href{#method-SearchResource-print}{\code{SearchResource$print()}}
\item \href{#method-SearchResource-clone}{\code{SearchResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new SearchResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-basic"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-basic}{}}}
\subsection{Method \code{basic()}}{
Basic concept search.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$basic(
  query,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  concept_class_ids = NULL,
  standard_concept = NULL,
  include_synonyms = FALSE,
  include_invalid = FALSE,
  min_score = NULL,
  exact_match = FALSE,
  page = 1,
  page_size = 20,
  sort_by = NULL,
  sort_order = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Search query string.}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domain_ids}}{Filter by domain IDs.}

\item{\code{concept_class_ids}}{Filter by concept class IDs.}

\item{\code{standard_concept}}{Filter by standard concept ("S", "C", or NULL).}

\item{\code{include_synonyms}}{Search in synonyms. Default \code{FALSE}.}

\item{\code{include_invalid}}{Include invalid concepts. Default \code{FALSE}.}

\item{\code{min_score}}{Minimum relevance score.}

\item{\code{exact_match}}{Require exact match. Default \code{FALSE}.}

\item{\code{page}}{Page number (1-based). Default 1.}

\item{\code{page_size}}{Results per page. Default 20.}

\item{\code{sort_by}}{Sort field.}

\item{\code{sort_order}}{Sort order ("asc" or "desc").}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-basic_all"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-basic_all}{}}}
\subsection{Method \code{basic_all()}}{
Fetch all search results with automatic pagination.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$basic_all(
  query,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  page_size = 100,
  max_pages = Inf,
  progress = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Search query string.}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domain_ids}}{Filter by domain IDs.}

\item{\code{page_size}}{Results per page. Default 100.}

\item{\code{max_pages}}{Maximum pages to fetch. Default Inf.}

\item{\code{progress}}{Show progress bar. Default \code{TRUE}.}

\item{\code{...}}{Additional search parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-advanced"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-advanced}{}}}
\subsection{Method \code{advanced()}}{
Advanced concept search with facets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$advanced(
  query,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  concept_class_ids = NULL,
  standard_concepts_only = FALSE,
  include_invalid = FALSE,
  relationship_filters = NULL,
  page = 1,
  page_size = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Search query string.}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domain_ids}}{Filter by domain IDs.}

\item{\code{concept_class_ids}}{Filter by concept class IDs.}

\item{\code{standard_concepts_only}}{Only return standard concepts. Default \code{FALSE}.}

\item{\code{include_invalid}}{Include invalid concepts. Default \code{FALSE}.}

\item{\code{relationship_filters}}{Relationship-based filters.}

\item{\code{page}}{Page number (1-based). Default 1.}

\item{\code{page_size}}{Results per page. Default 20.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-autocomplete"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-autocomplete}{}}}
\subsection{Method \code{autocomplete()}}{
Get autocomplete suggestions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$autocomplete(
  query,
  vocabulary_ids = NULL,
  domains = NULL,
  max_suggestions = 10
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Partial query string.}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domains}}{Filter by domains.}

\item{\code{max_suggestions}}{Maximum suggestions. Default 10.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
