% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgb.R
\name{cgb_smooth}
\alias{cgb_smooth}
\title{Apply a precomputed CGB graph to volumetric data}
\usage{
cgb_smooth(x, graph, passes = 1L, lambda = 1)
}
\arguments{
\item{x}{A \code{\linkS4class{NeuroVec}} (4D) or \code{\linkS4class{NeuroVol}} (3D).}

\item{graph}{Graph list returned by \code{\link{cgb_make_graph}}.}

\item{passes}{Number of smoothing passes (>=1). Each pass multiplies by
\code{W}; if \code{lambda < 1} a simple diffusion blend
\code{(1 - lambda)I + lambda W} is applied per pass.}

\item{lambda}{Blend factor in \eqn{[0,1]} controlling diffusion strength.}
}
\value{
Smoothed object of the same class as \code{x}.
}
\description{
Apply a precomputed CGB graph to volumetric data
}
