% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{emr_track.dbs}
\alias{emr_track.dbs}
\alias{emr_track.current_db}
\title{Returns a vector of db ids which have a
version of the track}
\usage{
emr_track.dbs(track, dataframe = FALSE)

emr_track.current_db(track, dataframe = FALSE)
}
\arguments{
\item{track}{one or more track names}

\item{dataframe}{return a data frame with with columns
called 'track' and 'db' instead of a vector of database ids.}
}
\value{
A named vector of db ids for each track. If \code{dataframe} is TRUE - returns a data frame with columns
called 'track' and 'db' with the track and database ids (multiple rows per track in the case of
\code{emr_track.dbs}).
}
\description{
\code{emr_track.dbs} returns all the databases which have a version of the track,
while \code{emr_track.current_db} returns the database from which 'naryn' currently takes
the track according to the override rules.
}
\examples{

# both db1 and db2 have a track named 'categorical_track'
emr_db.init_examples(2)
emr_track.dbs("categorical_track")
emr_track.dbs(emr_track.ls())

emr_track.current_db("categorical_track")
emr_track.current_db(emr_track.ls())

}
\seealso{
\code{\link{emr_track.info}}
}
\keyword{~connect}
\keyword{~db}
\keyword{~db_id}
\keyword{~info}
\keyword{~property}
\keyword{~track}
