% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_schemas.R
\name{cv_origami_schema}
\alias{cv_origami_schema}
\title{Cross-Validation with Origami}
\usage{
cv_origami_schema(
  data = data,
  n_folds = 5,
  fold_fun = origami::folds_vfold,
  cluster_ids = NULL,
  strata_ids = NULL,
  ...
)
}
\arguments{
\item{data}{a data.frame (or similar) to split into training and validation datasets.}

\item{n_folds}{The number of \code{training_data} and \code{validation_data} data frames to make.}

\item{fold_fun}{An \code{origami::folds_*} function}

\item{cluster_ids}{A vector of cluster ids. Clusters are treated as a unit –
that is, all observations within a cluster are placed in either the
training or validation set. See \code{?origami::make_folds}.}

\item{strata_ids}{A vector of strata ids. Strata are balanced: insofar as
possible the distribution in the sample should be the same as the
distribution in the training and validation sets. See \code{?origami::make_folds}.}

\item{...}{Extra arguments to be passed to \code{origami::make_folds()}}
}
\value{
A list of \code{n_folds} \code{training_data} and \code{validation_data} data.frames
}
\description{
Cross-Validation with Origami
}
\examples{

# to use origami::folds_vfold behind the scenes, just tell nadir::super_learner
# you want to use cv_origami_schema.

sl_model <- super_learner(
  data = mtcars,
  formula = mpg ~ cyl + hp,
  learners = list(rf = lnr_rf, lm = lnr_lm, mean = lnr_mean),
  cv_schema = cv_origami_schema
 )

# if you want to use a different origami::folds_* function, pass it into cv_origami_schema
sl_model <- super_learner(
  data = mtcars,
  formula = mpg ~ cyl + hp,
  learners = list(rf = lnr_rf, lm = lnr_lm, mean = lnr_mean),
  cv_schema = \(data, n_folds) {
    cv_origami_schema(data, n_folds, fold_fun = origami::folds_loo)
    }
 )
}
