% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-higher.R
\name{deriv_n}
\alias{deriv_n}
\title{Extract the k-th derivative from a nested dual result}
\usage{
deriv_n(d, k)
}
\arguments{
\item{d}{A (possibly nested) dual number, or a numeric.}

\item{k}{A non-negative integer: 0 for the function value, 1 for the
first derivative, etc.}
}
\value{
A numeric value.
}
\description{
After evaluating a function on a dual created by
\code{\link{dual_variable_n}}, use \code{deriv_n} to extract any
derivative from 0 (the function value) up to the seeded order.
}
\examples{
x <- dual_variable_n(1, order = 3)
r <- exp(x)
deriv_n(r, 0)
deriv_n(r, 1)
deriv_n(r, 2)
deriv_n(r, 3)
}
