% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macro-average-specificity.R
\name{macro_average_specificity}
\alias{macro_average_specificity}
\alias{macro_average_specificity_vec}
\alias{macro_average_specificity.data.frame}
\title{Macro Average Specificity}
\usage{
macro_average_specificity_vec(
  truth,
  estimate,
  estimator = NULL,
  na_rm = TRUE,
  case_weights = NULL,
  event_level = "first",
  ...
)

macro_average_specificity(data, ...)

\method{macro_average_specificity}{data.frame}(
  data,
  truth,
  estimate,
  estimator = NULL,
  na_rm = TRUE,
  case_weights = NULL,
  event_level = "first",
  ...
)
}
\arguments{
\item{truth}{The column identifier for the true class results (that is a factor).}

\item{estimate}{The column identifier for the predicted class results (that is also factor).}

\item{estimator}{One of: "binary", "macro", "macro_weighted", or "micro" to specify the type of averaging to be done.}

\item{na_rm}{A logical value indicating whether NA values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.}

\item{event_level}{A single string. Either "first" or "second" to specify which level of truth to consider as the "event".
This argument is only applicable when estimator = "binary".}

\item{...}{Currently unused.}

\item{data}{Either a data.frame containing the columns specified by the truth and estimate
arguments, or a table/matrix where the true class results should be in the columns of the table.}
}
\value{
A scalar storing the value of the macro-average specificity score.
}
\description{
This function computes the macro-average specificity for a multi-class prediction model.
It assumes that the \emph{negative} class is the first one.
}
\examples{
fold1 <- subset(yardstick::hpc_cv, Resample == "Fold01")
macro_average_specificity_vec(fold1$obs, fold1$pred)
macro_average_specificity(fold1, obs, pred)
}
