% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{profile}
\alias{profile}
\alias{profile.MSAassess}
\alias{plot.MSAprof}
\title{Profile parameters of MSA model}
\usage{
\method{profile}{MSAassess}(fitted, p1, v1, p2, v2, cores = 1, ...)

\method{plot}{MSAprof}(
  x,
  component = "objective",
  rel = TRUE,
  xlab,
  ylab,
  main,
  plot2d = c("contour", "filled.contour"),
  ...
)
}
\arguments{
\item{fitted}{\linkS4class{MSAassess} object returned by \code{\link[=fit_MSA]{fit_MSA()}}}

\item{p1}{Character string that represents the first parameter to be profiled,
including the parameter name and index of the vector/array. See "Parameters" section of \code{\link[=make_parameters]{make_parameters()}}.
Additionally, this function allows users to specify \code{R0_s} and \code{h_s} (in normal units).}

\item{v1}{Vector of values corresponding to \code{p1}}

\item{p2}{Character string that represents the optional second parameter to be profiled}

\item{v2}{Vector of values corresponding to \code{p2}}

\item{cores}{Integer for the number of cores to use for parallel processing (snowfall package)}

\item{...}{Other argument to the base graphics function, i.e., either plot() or contour()}

\item{x}{Output from \code{\link[=profile.MSAassess]{profile.MSAassess()}}}

\item{component}{Character for the column in \code{x} to be plotted}

\item{rel}{Logical, whether the relative change in \code{component} is plotted (TRUE) or the raw values (FALSE)}

\item{xlab}{Optional character for the x-axis label}

\item{ylab}{Optional character for the y-axis label}

\item{main}{Optional character for the plot title}

\item{plot2d}{Character, plotting function for two-dimensional profiling (either a \code{\link[=contour]{contour()}} or \code{\link[=filled.contour]{filled.contour()}} plot)}
}
\value{
The profile generic returns a data frame of the likelihood values that correspond to
fixed values of \code{p1} and \code{p2}.
\itemize{
\item Likelihood \code{loglike} refers to maximizing the probability of the observed data (higher values for better fit)
\item Prior \code{logprior} refers to maximizing the probability of a parameter to their prior distribution (higher values are closer to the prior mode)
\item Penalty \code{penalty} are values added to the objective function when parameters exceed model bounds (lower values are better)
\item \code{fn} is the objective function returned by RTMB (lower values are better)
\item \code{objective} is the objective function returned by the optimizer (lower values are better)
}

The accompanying plot function returns a line plot for a 1-dimensional profile or a contour plot for a two
dimensional profile. Will plot the negative log likelihood or negative log prior (better fit with lower values).

Relative values are obtained by subtracting from the fitted value. See \code{attr(x, "fitted")}
}
\description{
Evaluate change in objective function and likelihood components for up to 2 parameters.
}
