% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectivity.R
\name{conv_selpar}
\alias{conv_selpar}
\alias{calc_sel_len}
\alias{calc_fsel_age}
\alias{calc_isel_age}
\title{Selectivity at age and length}
\usage{
conv_selpar(x, type, maxage, maxL)

calc_sel_len(sel_par, lmid, type)

calc_fsel_age(
  sel_len,
  LAK,
  type,
  sel_par,
  sel_block = seq(1, length(type)),
  mat,
  a = seq(1, nrow(LAK)) - 1
)

calc_isel_age(
  sel_len,
  LAK,
  type,
  sel_par,
  fsel_age,
  maxage,
  mat,
  a = seq(1, nrow(LAK)) - 1
)
}
\arguments{
\item{x}{Estimated parameters. Matrix \verb{[3, f]}}

\item{type}{Character string to indicate the functional form of selectivity. Options include:
\verb{"logistic_length", "dome_length", "logistic_age", "dome_age"}, an integer (\code{f}) to map index selectivity
to the corresponding fleet \code{f} (will be coerced to integer), \code{"SB"} to fix to maturity at age schedule, or \code{"B"} to fix to 1 for all ages.}

\item{maxage}{Maximum value of the age of full selectivity}

\item{maxL}{Maximum value of the length of full selectivity}

\item{sel_par}{Matrix of parameters returned by \code{\link[=conv_selpar]{conv_selpar()}}}

\item{lmid}{Midpoints of length bins for calculating selectivity at length}

\item{sel_len}{Selectivity at length matrix returned by \code{\link[=calc_sel_len]{calc_sel_len()}}}

\item{LAK}{Length-at-age probability matrix. Matrix \verb{[a, length(lmid)]}}

\item{sel_block}{Integer vector. Length \code{length(type)}. See details below.}

\item{mat}{Maturity at age vector}

\item{a}{Integer vector of ages corresponding to the rows of \code{LAK} (as well as \code{mat})}

\item{fsel_age}{Matrix returned by \code{\link[=calc_fsel_age]{calc_fsel_age()}}}
}
\value{
\code{\link[=conv_selpar]{conv_selpar()}} returns a matrix of the same dimensions as \code{x}.

\code{\link[=calc_sel_len]{calc_sel_len()}} returns a matrix \verb{[l, f]}, i.e., \verb{[length(lmid), length(type)]}.

\code{\link[=calc_fsel_age]{calc_fsel_age()}} returns a matrix \verb{[a, f]}, i.e., \verb{[a, length(sel_block)]}

\code{\link[=calc_isel_age]{calc_isel_age()}} returns a matrix \verb{[a, i]}, i.e., \verb{[a, length(type)]}
}
\description{
Calculate selectivity at age and length from a matrix of parameters.
\itemize{
\item \code{\link[=conv_selpar]{conv_selpar()}} converts parameters from log or logit space to real units.
\item \code{\link[=calc_sel_len]{calc_sel_len()}} calculates selectivity at length.
\item \code{\link[=calc_fsel_age]{calc_fsel_age()}} calculates selectivity at age for fisheries, and coordinates dummy fleets.
\item \code{\link[=calc_isel_age]{calc_isel_age()}} calculates selectivity at age for indices, and can map selectivity from fisheries
or population parameters (e.g, mature or total biomass).
}
}
\section{Converting selectivity parameters (conv_selpar)}{

The first row of \code{x} corresponds to the length or age of full selectivity: \eqn{\mu_f = L_{max}/(1 + \exp(-x_{1,f}))}

The second row of \code{x} corresponds to the width of the ascending limb for selectivity:
\eqn{\sigma_f^{asc} = \exp(x_{2,f})}

The third row of \code{x} corresponds to the width of the descending limb for selectivity (if dome-shaped):
\eqn{\sigma_f^{des} = \exp(x_{3,f})}
}

\section{Length selectivity (calc_sel_len)}{

The selectivity at length is
\deqn{
s_{\ell} =
\begin{cases}
\exp(\alpha) & L_{\ell} < \mu_f\\
\exp(\beta) & L_{\ell} \ge \mu_f\\
\end{cases}
}
where
\eqn{
\alpha = -0.5(L_\ell - \mu_f)^2/(\sigma_f^{asc})^2
}
and
\eqn{
\beta = -0.5(L_\ell - \mu_f)^2/(\sigma_f^{des})^2
}
}

\section{Age selectivity (calc_fsel_age)}{

The equivalent selectivity at age is converted from the length values (\code{sel_len}) as
\deqn{
s_a = \sum_\ell s_\ell \times \textrm{Prob}(L_{\ell}|a)
}

If selectivity is explicitly in age units, then the values are directly calculated
from parameters in \code{sel_par}.

Vector \code{sel_block} assigns the output selectivity from a different column of the input matrix
and facilitates time-varying selectivity in time blocks. For example, \code{sel_block[1] <- 2} means
that selectivity values in the first column of the output is based on the second column of the
input matrices (\code{sel_len[, 2]} or \code{sel_par[, 2]}).
}

