% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMD_wrappers.R
\name{SMD_ind}
\alias{SMD_ind}
\title{Simple effect: Standardized Mean Difference}
\usage{
SMD_ind(
  data,
  col_names = c("yi", "vi"),
  append = TRUE,
  hedges_correction = TRUE,
  Ctrl_mean,
  Ctrl_sd,
  Ctrl_n,
  A_mean,
  A_sd,
  A_n
)
}
\arguments{
\item{data}{Data frame containing the variables used.}

\item{col_names}{Vector of two strings to name the output columns for the effect size and its sampling variance. Default is 'yi' and 'vi'.}

\item{append}{Logical. Append the results to \code{data}. Default is TRUE}

\item{hedges_correction}{Boolean. If TRUE correct for small-sample bias. Default is TRUE.}

\item{Ctrl_mean}{Mean outcome from the Control treatment}

\item{Ctrl_sd}{Standard deviation from the control treatment}

\item{Ctrl_n}{Sample size from the control treatment}

\item{A_mean}{Mean outcome from the experimental treatment}

\item{A_sd}{Standard deviation from the experimental treatment}

\item{A_n}{Sample size from the experimental treatment}
}
\value{
A data frame containing the effect sizes and their sampling variance.
By default, the columns are named \code{yi} (effect size) and \code{vi} (sampling variance).
If \code{append = TRUE}, the results are appended to the input \code{data}; otherwise, only the computed effect size columns are returned.
}
\description{
Computes the individual or simple effect of Factor A over the Control.
}
\details{
It is the classic Standardized Mean Difference (SMD), which can also be computed
with metafor's \code{escalc()} function using \code{measure = "SMD"}.

See the package vignette for a detailed description of the formula.
}
\examples{
data <- data.frame(
  study_id = 1:3,
  control_mean = c(45.2, 52.8, 38.9),
  control_sd = c(8.1, 11.2, 7.3),
  control_n = c(18, 23, 16),
  pollinator_exclusion_mean = c(28.7, 35.4, 22.1),
  pollinator_exclusion_sd = c(6.8, 9.1, 5.9),
  pollinator_exclusion_n = c(20, 22, 18)
)

# With Hedges' correction (default)
result <- SMD_ind(
  data = data,
  Ctrl_mean = "control_mean",
  Ctrl_sd = "control_sd",
  Ctrl_n = "control_n",
  A_mean = "pollinator_exclusion_mean",
  A_sd = "pollinator_exclusion_sd",
  A_n = "pollinator_exclusion_n",
  hedges_correction = TRUE
)

# Without Hedges' correction
result_no_hedges <- SMD_ind(
  data = data,
  Ctrl_mean = "control_mean",
  Ctrl_sd = "control_sd",
  Ctrl_n = "control_n",
  A_mean = "pollinator_exclusion_mean",
  A_sd = "pollinator_exclusion_sd",
  A_n = "pollinator_exclusion_n",
  hedges_correction = FALSE
)

}
\references{
Gurevitch, J., Morrison, J. A., & Hedges, L. V. (2000). The interaction
between competition and predation: a meta-analysis of field experiments.
The American Naturalist, 155(4), 435-453.

Morris, W. F., Hufbauer, R. A., Agrawal, A. A., Bever, J. D., Borowicz, V. A.,
Gilbert, G. S., ... & Vázquez, D. P. (2007). Direct and interactive
effects of enemies and mutualists on plant performance: a meta‐analysis.
Ecology, 88(4), 1021-1029. https://doi.org/10.1890/06-0442
}
\author{
Facundo Decunta - fdecunta@agro.uba.ar
}
