% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LeadAgent.R
\name{LeadAgent}
\alias{LeadAgent}
\title{LeadAgent: A Multi-Agent Orchestration Coordinator}
\description{
`LeadAgent` extends `Agent` to coordinate a group of specialized agents.
It decomposes complex prompts into subtasks using LLMs and assigns each subtask to the most suitable registered agent.
The lead agent handles response chaining, where each agent can consider prior results.
}
\details{
This class builds intelligent multi-agent workflows by delegating sub-tasks using `delegate_prompt()`,
executing them with `invoke()`, and storing the results in the `agents_interaction` list.
}
\examples{

## ------------------------------------------------
## Method `LeadAgent$new`
## ------------------------------------------------


  # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )



## ------------------------------------------------
## Method `LeadAgent$clear_agents`
## ------------------------------------------------

  # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. ",
   "Your job is to answer factual questions with detailed and accurate information. ",
   "Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = paste0(
   "You are an agent designed to summarise ",
   "a given text into 3 distinct bullet points."
   ),
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )
 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$agents

 lead_agent$clear_agents()

 lead_agent$agents


## ------------------------------------------------
## Method `LeadAgent$remove_agents`
## ------------------------------------------------

  # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. ",
   "Your job is to answer factual questions with detailed and accurate information. ",
   "Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = "You are agent designed to summarise a given text into 3 distinct bullet points.",
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )


 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$agents

 # deleting the translator agent

 id_translator_agent <- translator$agent_id

 lead_agent$remove_agents(id_translator_agent)

 lead_agent$agents


## ------------------------------------------------
## Method `LeadAgent$register_agents`
## ------------------------------------------------

  # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. ",
   "Your job is to answer factual questions with detailed and accurate information. ",
   "Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = "You are agent designed to summarise a given text into 3 distinct bullet points.",
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$agents

## ------------------------------------------------
## Method `LeadAgent$invoke`
## ------------------------------------------------

\dontrun{
 # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. ",
   "Your job is to answer factual questions with detailed ",
   "and accurate information. Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = "You are agent designed to summarise a given text into 3 distinct bullet points.",
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$invoke(
 paste0(
  "Describe the economic situation in Algeria in 3 sentences. ",
  "Answer in German"
  )
 )
}

## ------------------------------------------------
## Method `LeadAgent$generate_plan`
## ------------------------------------------------

\dontrun{
 # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. Your job is to answer factual questions ",
   "with detailed and accurate information. Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = "You are agent designed to summarise a given text into 3 distinct bullet points.",
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$generate_plan(
 paste0(
  "Describe the economic situation in Algeria in 3 sentences. ",
  "Answer in German"
  )
 )
}

## ------------------------------------------------
## Method `LeadAgent$broadcast`
## ------------------------------------------------

\dontrun{
 # An API KEY is required in order to invoke the agents
openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
openai_4_1 <- ellmer::chat(
  name = "openai/gpt-4.1",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)

openai_4_1_agent <- Agent$new(
  name = "openai_4_1_agent",
  instruction = "You are an AI assistant. Answer in 1 sentence max.",
  llm_object = openai_4_1
)

openai_4_1_nano <- ellmer::chat(
  name = "openai/gpt-4.1-nano",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)

openai_4_1_nano_agent <- Agent$new(
  name = "openai_4_1_nano_agent",
  instruction = "You are an AI assistant. Answer in 1 sentence max.",
  llm_object = openai_4_1_nano
  )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

lead_agent$register_agents(c(openai_4_1_agent, openai_4_1_nano_agent))
lead_agent$broadcast(
  prompt = paste0(
    "If I were Algerian, which song would I like to sing ",
    "when running under the rain? how about a flower?"
  )
  )
}

## ------------------------------------------------
## Method `LeadAgent$set_hitl`
## ------------------------------------------------

\dontrun{
 # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
    "You are a research assistant. ",
    "Your job is to answer factual questions with detailed and accurate information. ",
    "Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = paste0(
   "You are agent designed to summarise a give text ",
   "into 3 distinct bullet points."
   ),
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 # setting a human in the loop in step 2
 lead_agent$set_hitl(1)

 # The execution will stop at step 2 and a human will be able
 # to either accept the answer, modify it or stop the execution of
 # the workflow

 lead_agent$invoke(
 paste0(
  "Describe the economic situation in Algeria in 3 sentences. ",
  "Answer in German"
  )
 )
}

## ------------------------------------------------
## Method `LeadAgent$judge_and_choose_best_response`
## ------------------------------------------------

\dontrun{
openai_4_1_mini <- ellmer::chat(
  name = "openai/gpt-4.1-mini",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)
openai_4_1 <- ellmer::chat(
  name = "openai/gpt-4.1",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)

stylist <- Agent$new(
  name = "stylist",
  instruction = "You are an AI assistant. Answer in 1 sentence max.",
  llm_object = openai_4_1
)

openai_4_1_nano <- ellmer::chat(
  name = "openai/gpt-4.1-nano",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)

stylist2 <- Agent$new(
  name = "stylist2",
  instruction = "You are an AI assistant. Answer in 1 sentence max.",
  llm_object = openai_4_1_nano
)

lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
)

lead_agent$register_agents(c(stylist, stylist2))

lead_agent$judge_and_choose_best_response("what's the best way to war a kalvin klein shirt?")

}
}
\section{Super class}{
\code{\link[mini007:Agent]{mini007::Agent}} -> \code{LeadAgent}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{agents}}{A named list of registered sub-agents (by UUID).}

\item{\code{agents_interaction}}{A list of delegated task history with agent IDs, prompts, and responses.}

\item{\code{plan}}{A list containing the most recently generated task plan.}

\item{\code{hitl_steps}}{The steps where the workflow should be stopped in order to allow for a human interaction}

\item{\code{prompt_for_plan}}{The prompt used to generate the plan.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LeadAgent-new}{\code{LeadAgent$new()}}
\item \href{#method-LeadAgent-clear_agents}{\code{LeadAgent$clear_agents()}}
\item \href{#method-LeadAgent-remove_agents}{\code{LeadAgent$remove_agents()}}
\item \href{#method-LeadAgent-register_agents}{\code{LeadAgent$register_agents()}}
\item \href{#method-LeadAgent-visualize_plan}{\code{LeadAgent$visualize_plan()}}
\item \href{#method-LeadAgent-invoke}{\code{LeadAgent$invoke()}}
\item \href{#method-LeadAgent-generate_plan}{\code{LeadAgent$generate_plan()}}
\item \href{#method-LeadAgent-broadcast}{\code{LeadAgent$broadcast()}}
\item \href{#method-LeadAgent-set_hitl}{\code{LeadAgent$set_hitl()}}
\item \href{#method-LeadAgent-judge_and_choose_best_response}{\code{LeadAgent$judge_and_choose_best_response()}}
\item \href{#method-LeadAgent-clone}{\code{LeadAgent$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="add_message"><a href='../../mini007/html/Agent.html#method-Agent-add_message'><code>mini007::Agent$add_message()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="clear_and_summarise_messages"><a href='../../mini007/html/Agent.html#method-Agent-clear_and_summarise_messages'><code>mini007::Agent$clear_and_summarise_messages()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="export_messages_history"><a href='../../mini007/html/Agent.html#method-Agent-export_messages_history'><code>mini007::Agent$export_messages_history()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="generate_execute_r_code"><a href='../../mini007/html/Agent.html#method-Agent-generate_execute_r_code'><code>mini007::Agent$generate_execute_r_code()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="get_usage_stats"><a href='../../mini007/html/Agent.html#method-Agent-get_usage_stats'><code>mini007::Agent$get_usage_stats()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="keep_last_n_messages"><a href='../../mini007/html/Agent.html#method-Agent-keep_last_n_messages'><code>mini007::Agent$keep_last_n_messages()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="load_messages_history"><a href='../../mini007/html/Agent.html#method-Agent-load_messages_history'><code>mini007::Agent$load_messages_history()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="reset_conversation_history"><a href='../../mini007/html/Agent.html#method-Agent-reset_conversation_history'><code>mini007::Agent$reset_conversation_history()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="set_budget"><a href='../../mini007/html/Agent.html#method-Agent-set_budget'><code>mini007::Agent$set_budget()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="set_budget_policy"><a href='../../mini007/html/Agent.html#method-Agent-set_budget_policy'><code>mini007::Agent$set_budget_policy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mini007" data-topic="Agent" data-id="update_instruction"><a href='../../mini007/html/Agent.html#method-Agent-update_instruction'><code>mini007::Agent$update_instruction()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-new"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-new}{}}}
\subsection{Method \code{new()}}{
Initializes the LeadAgent with a built-in task-decomposition prompt.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$new(name, llm_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A short name for the coordinator (e.g. `"lead"`).}

\item{\code{llm_object}}{The LLM object generate by ellmer (eg. output of ellmer::chat_openai)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{
  # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )


}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-clear_agents"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-clear_agents}{}}}
\subsection{Method \code{clear_agents()}}{
Clear out the registered Agents
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$clear_agents()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{  # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. ",
   "Your job is to answer factual questions with detailed and accurate information. ",
   "Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = paste0(
   "You are an agent designed to summarise ",
   "a given text into 3 distinct bullet points."
   ),
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )
 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$agents

 lead_agent$clear_agents()

 lead_agent$agents

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-remove_agents"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-remove_agents}{}}}
\subsection{Method \code{remove_agents()}}{
Remove registered agents by IDs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$remove_agents(agent_ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent_ids}}{The Agent ID to remove from the registered Agents}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{  # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. ",
   "Your job is to answer factual questions with detailed and accurate information. ",
   "Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = "You are agent designed to summarise a given text into 3 distinct bullet points.",
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )


 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$agents

 # deleting the translator agent

 id_translator_agent <- translator$agent_id

 lead_agent$remove_agents(id_translator_agent)

 lead_agent$agents

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-register_agents"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-register_agents}{}}}
\subsection{Method \code{register_agents()}}{
Register one or more agents for delegation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$register_agents(agents)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agents}}{A vector of `Agent` objects to register.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{  # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. ",
   "Your job is to answer factual questions with detailed and accurate information. ",
   "Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = "You are agent designed to summarise a given text into 3 distinct bullet points.",
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$agents
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-visualize_plan"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-visualize_plan}{}}}
\subsection{Method \code{visualize_plan()}}{
Visualizes the orchestration plan
Each agent node is shown in sequence (left → right), with tooltips showing
the actual prompt delegated to that agent.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$visualize_plan()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-invoke"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-invoke}{}}}
\subsection{Method \code{invoke()}}{
Executes the full prompt pipeline: decomposition → delegation → invocation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$invoke(prompt, force_regenerate_plan = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{The complex user instruction to process.}

\item{\code{force_regenerate_plan}}{If TRUE, regenerate a plan even if one exists,
defaults to FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The final response (from the last agent in the sequence).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. ",
   "Your job is to answer factual questions with detailed ",
   "and accurate information. Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = "You are agent designed to summarise a given text into 3 distinct bullet points.",
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$invoke(
 paste0(
  "Describe the economic situation in Algeria in 3 sentences. ",
  "Answer in German"
  )
 )
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-generate_plan"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-generate_plan}{}}}
\subsection{Method \code{generate_plan()}}{
Generates a task execution plan without executing the subtasks.
It returns a structured list containing the subtask, the selected agent, and metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$generate_plan(prompt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{A complex instruction to be broken into subtasks.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of lists containing agent_id, agent_name, model_name, model_provider, and the assigned prompt.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
   "You are a research assistant. Your job is to answer factual questions ",
   "with detailed and accurate information. Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = "You are agent designed to summarise a given text into 3 distinct bullet points.",
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 lead_agent$generate_plan(
 paste0(
  "Describe the economic situation in Algeria in 3 sentences. ",
  "Answer in German"
  )
 )
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-broadcast"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-broadcast}{}}}
\subsection{Method \code{broadcast()}}{
Broadcasts a prompt to all registered agents and collects their responses.
This does not affect the main agent orchestration logic or history.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$broadcast(prompt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{A user prompt to send to all agents.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of responses from all agents.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # An API KEY is required in order to invoke the agents
openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
openai_4_1 <- ellmer::chat(
  name = "openai/gpt-4.1",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)

openai_4_1_agent <- Agent$new(
  name = "openai_4_1_agent",
  instruction = "You are an AI assistant. Answer in 1 sentence max.",
  llm_object = openai_4_1
)

openai_4_1_nano <- ellmer::chat(
  name = "openai/gpt-4.1-nano",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)

openai_4_1_nano_agent <- Agent$new(
  name = "openai_4_1_nano_agent",
  instruction = "You are an AI assistant. Answer in 1 sentence max.",
  llm_object = openai_4_1_nano
  )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

lead_agent$register_agents(c(openai_4_1_agent, openai_4_1_nano_agent))
lead_agent$broadcast(
  prompt = paste0(
    "If I were Algerian, which song would I like to sing ",
    "when running under the rain? how about a flower?"
  )
  )
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-set_hitl"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-set_hitl}{}}}
\subsection{Method \code{set_hitl()}}{
Set Human In The Loop (HITL) interaction at determined steps within the workflow
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$set_hitl(steps)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{steps}}{At which steps the Human In The Loop is required?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of responses from all agents.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # An API KEY is required in order to invoke the agents
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )
 researcher <- Agent$new(
   name = "researcher",
   instruction = paste0(
    "You are a research assistant. ",
    "Your job is to answer factual questions with detailed and accurate information. ",
    "Do not answer with more than 2 lines"
   ),
   llm_object = openai_4_1_mini
 )

 summarizer <- Agent$new(
   name = "summarizer",
   instruction = paste0(
   "You are agent designed to summarise a give text ",
   "into 3 distinct bullet points."
   ),
   llm_object = openai_4_1_mini
 )

 translator <- Agent$new(
   name = "translator",
   instruction = "Your role is to translate a text from English to German",
   llm_object = openai_4_1_mini
 )

 lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
 )

 lead_agent$register_agents(c(researcher, summarizer, translator))

 # setting a human in the loop in step 2
 lead_agent$set_hitl(1)

 # The execution will stop at step 2 and a human will be able
 # to either accept the answer, modify it or stop the execution of
 # the workflow

 lead_agent$invoke(
 paste0(
  "Describe the economic situation in Algeria in 3 sentences. ",
  "Answer in German"
  )
 )
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-judge_and_choose_best_response"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-judge_and_choose_best_response}{}}}
\subsection{Method \code{judge_and_choose_best_response()}}{
The Lead Agent send a prompt to its registered agents and choose the best response
from the agents' responses
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$judge_and_choose_best_response(prompt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{The prompt to send to the registered agents}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of responses from all agents, including the chosen response
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
openai_4_1_mini <- ellmer::chat(
  name = "openai/gpt-4.1-mini",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)
openai_4_1 <- ellmer::chat(
  name = "openai/gpt-4.1",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)

stylist <- Agent$new(
  name = "stylist",
  instruction = "You are an AI assistant. Answer in 1 sentence max.",
  llm_object = openai_4_1
)

openai_4_1_nano <- ellmer::chat(
  name = "openai/gpt-4.1-nano",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  echo = "none"
)

stylist2 <- Agent$new(
  name = "stylist2",
  instruction = "You are an AI assistant. Answer in 1 sentence max.",
  llm_object = openai_4_1_nano
)

lead_agent <- LeadAgent$new(
  name = "Leader",
  llm_object = openai_4_1_mini
)

lead_agent$register_agents(c(stylist, stylist2))

lead_agent$judge_and_choose_best_response("what's the best way to war a kalvin klein shirt?")

}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LeadAgent-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LeadAgent-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeadAgent$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
