% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailindex.R
\name{shape.genquant}
\alias{shape.genquant}
\title{Beirlant et al. generalized quantile shape estimator}
\usage{
shape.genquant(
  xdat,
  k,
  type = c("genmean", "genmed", "trimmean"),
  weight,
  p = 0.5
)
}
\arguments{
\item{xdat}{\code{n} vector of observations}

\item{k}{number of upper order statistics}

\item{type}{string indicating the estimator choice, one of \code{genmean}, \code{genmed} and \code{trimmean}.}

\item{weight}{weight a kernel function on \eqn{[0,1]}}

\item{p}{number between zero and one giving the proportion of order statistics for the second threshold}
}
\description{
This estimator estimates the real shape parameter based on generalized quantile plots based on mean excess functions, generalized median excesses or trimmed mean excesses.
}
\references{
Beirlant, J., Vynckier P. and J.L. Teugels (1996). \emph{Excess functions and estimation of the extreme-value index.} Bernoulli, 2(\bold{4}), 293-318.
}
