% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_interpolation.R
\name{interpolate_data}
\alias{interpolate_data}
\title{Interpolation process for spatial data}
\usage{
interpolate_data(
  spatial_data,
  interpolator,
  dates = NULL,
  variables = NULL,
  ignore_convex_hull_check = FALSE,
  verbose = getOption("meteoland_verbosity", TRUE)
)
}
\arguments{
\item{spatial_data}{An sf or stars raster object to interpolate}

\item{interpolator}{A meteoland interpolator object, as created by
\code{\link{create_meteo_interpolator}}}

\item{dates}{vector with dates to interpolate (must be within the
interpolator date range). Default to NULL (all dates present in the
interpolator object)}

\item{variables}{vector with variable names to be interpolated. NULL (default),
will interpolate all variables. Accepted names are "Temperature", "Precipitation",
"RelativeHumidity", "Radiation" and "Wind"}

\item{ignore_convex_hull_check}{Logical indicating whether errors in convex hull checks should be ignored.
Checking for points to be inside the convex hull will normally raise an error
if >10\% of points are outside. Setting \code{ignore_convex_hull_check = TRUE} means
that a warning is raised but interpolation is performed, which can be useful to users interpolating
on a few points close but outside of the convex hull.}

\item{verbose}{Logical indicating if the function must show messages and info.
Default value checks \code{"meteoland_verbosity"} option and if not set, defaults
to TRUE. It can be turned off for the function with FALSE, or session wide with
\code{options(meteoland_verbosity = FALSE)}}
}
\value{
an object with the same class and structure as the provided spatial
data with the results of the interpolation joined. In the case of spatial
data being an sf, the results are added as a list-type column that can be
unnested with \code{\link[tidyr]{unnest}}. In the case of a stars raster
object, interpolation results are added as attributes (variables)
}
\description{
Interpolate spatial data to obtain downscaled meteorologic variables
}
\details{
This function takes a spatial data object (sf or stars raster), an
interpolator object (\code{\link{create_meteo_interpolator}}) and a
vector of dates to perform the interpolation of the meteorologic variables
for the spatial locations present in the \code{spatial_data} object.
}
\section{Spatial data}{


The spatial data provided must be of two types. (I) A sf object containing
POINT for each location to interpolate or (II) a stars raster object for
which the interpolation should be done. Independently of the class of
\code{spatial_data} it has to have some mandatory variables, namely
\code{elevation}. It should also contain \code{aspect} and \code{slope} for
a better interpolation process, though this two variables are not mandatory.
}

\examples{

\donttest{
# example of data to interpolate and example interpolator
data("points_to_interpolate_example")
data("meteoland_interpolator_example")

# interpolate data
res <- interpolate_data(points_to_interpolate_example, meteoland_interpolator_example)

# check result
# same class as input data
class(res)
# data
res
# results for the first location
res[["interpolated_data"]][1]
# unnest results
tidyr::unnest(res, cols = "interpolated_data")
}

}
\author{
Victor Granda \enc{García}{Garcia}, EMF-CREAF

Miquel De \enc{Cáceres}{Caceres} Ainsa, EMF-CREAF
}
