% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{view_graph}
\alias{view_graph}
\title{View graph}
\usage{
view_graph(svy, init_step = "Load survey")
}
\arguments{
\item{svy}{Survey object}

\item{init_step}{Initial step label (default: "Load survey")}
}
\value{
A visNetwork interactive graph of the survey processing steps.
}
\description{
View graph
}
\examples{
\donttest{
dt <- data.table::data.table(
  id = 1:5, age = c(25, 30, 45, 50, 60),
  w = rep(1, 5)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "ech",
  psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w")
)
svy <- step_compute(svy, age2 = age * 2)
view_graph(svy)
}
}
\seealso{
Other steps: 
\code{\link{bake_steps}()},
\code{\link{get_steps}()},
\code{\link{step_compute}()},
\code{\link{step_filter}()},
\code{\link{step_join}()},
\code{\link{step_recode}()},
\code{\link{step_remove}()},
\code{\link{step_rename}()},
\code{\link{step_validate}()}
}
\concept{steps}
\keyword{step}
\keyword{survey}
