% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpile.R
\name{transpile_coverage}
\alias{transpile_coverage}
\title{Analyze transpilation coverage for STATA do-files}
\usage{
transpile_coverage(path, recursive = TRUE)
}
\arguments{
\item{path}{Path to a .do file or directory of .do files}

\item{recursive}{If TRUE and path is a directory, search subdirectories}
}
\value{
A data.frame with columns: file, total_commands, translated,
skipped, manual_review, coverage_pct
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Reports what percentage of commands in a .do file (or directory
of files) can be automatically transpiled vs require manual review.
}
\examples{
\donttest{
tf <- tempfile(fileext = ".do")
writeLines(c("gen x = 1", "replace x = 2 if y == 3", "drop z"), tf)
transpile_coverage(tf)
}
}
\seealso{
Other transpiler: 
\code{\link{parse_do_file}()},
\code{\link{parse_stata_labels}()},
\code{\link{transpile_stata}()},
\code{\link{transpile_stata_module}()}
}
\concept{transpiler}
