% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recipes.R
\name{steps_to_recipe}
\alias{steps_to_recipe}
\title{Convert a list of steps to a recipe}
\usage{
steps_to_recipe(
  name,
  user,
  svy = survey_empty(type = "eaii", edition = "2019-2021"),
  description,
  steps,
  doi = NULL,
  topic = NULL
)
}
\arguments{
\item{name}{A character string with the name of the recipe}

\item{user}{A character string with the user of the recipe}

\item{svy}{A Survey object}

\item{description}{A character string with the description of the recipe}

\item{steps}{A list with the steps of the recipe}

\item{doi}{A character string with the DOI of the recipe}

\item{topic}{A character string with the topic of the recipe}
}
\value{
A Recipe object
}
\description{
Convert a list of steps to a recipe
}
\examples{
\donttest{
dt <- data.table::data.table(
  id = 1:20, age = sample(18:65, 20, TRUE),
  w = runif(20, 0.5, 2)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "demo",
  psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w")
)
svy <- step_compute(svy, age2 = age^2)
my_recipe <- steps_to_recipe(
  name = "age_vars", user = "analyst",
  svy = svy, description = "Age-derived variables",
  steps = get_steps(svy)
)
my_recipe
}
}
\seealso{
Other recipes: 
\code{\link{Recipe-class}},
\code{\link{add_recipe}()},
\code{\link{bake_recipes}()},
\code{\link{explore_recipes}()},
\code{\link{get_recipe}()},
\code{\link{print.Recipe}()},
\code{\link{publish_recipe}()},
\code{\link{read_recipe}()},
\code{\link{recipe}()},
\code{\link{save_recipe}()}
}
\concept{recipes}
\keyword{recipe}
\keyword{step}
\keyword{survey}
