% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step.R
\name{bake_steps}
\alias{bake_steps}
\title{Execute all pending steps}
\usage{
bake_steps(svy)
}
\arguments{
\item{svy}{A \code{Survey} or \code{RotativePanelSurvey} object with pending steps}
}
\value{
The same object with all steps materialized in the data
and each step marked as \code{bake = TRUE}.
}
\description{
Iterates over all pending (lazy) steps attached to a Survey or
RotativePanelSurvey and executes them sequentially, mutating
the underlying data.table. Each step is validated before execution
(checks that required variables exist).
}
\details{
Steps are executed in the order they were added. Each step's expressions
can reference variables created by previous steps.

For RotativePanelSurvey objects, steps are applied to both the
implantation and all follow-up surveys.
}
\examples{
dt <- data.table::data.table(id = 1:5, age = c(15, 30, 45, 50, 70), w = 1)
svy <- Survey$new(
  data = dt, edition = "2023", type = "test",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)
svy <- step_compute(svy, age2 = age * 2)
svy <- bake_steps(svy)
get_data(svy)
}
\seealso{
Other steps: 
\code{\link{get_steps}()},
\code{\link{step_compute}()},
\code{\link{step_filter}()},
\code{\link{step_join}()},
\code{\link{step_recode}()},
\code{\link{step_remove}()},
\code{\link{step_rename}()},
\code{\link{step_validate}()},
\code{\link{view_graph}()}
}
\concept{steps}
