% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_charlson_index_scores.R
\name{get_charlson_index_scores}
\alias{get_charlson_index_scores}
\title{Get Charlson Index Scores}
\usage{
get_charlson_index_scores()
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{condition}: Character vector of the conditions
\item \code{index}: Character vector indicating if the score is for the mortality or the readmission index score
\item \verb{charlson_<variant>}:  the index scores for the variant
}
}
\description{
Retrieve a copy of internal lookup tables of index scores used in assessing
Charlson comorbidities.
}
\examples{
head(get_charlson_index_scores())
str(get_charlson_index_scores())

}
\seealso{
\itemize{
\item \code{\link[=get_charlson_codes]{get_charlson_codes()}} for a lookup table of the ICD codes mapping to the
Charlson comorbidities.
\item \code{\link[=comorbidities]{comorbidities()}} for applying comorbidity algorithms to a data set.
}
}
