% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-reliability.R
\name{reliability}
\alias{reliability}
\title{Estimate the reliability of a diagnostic classification model}
\usage{
reliability(x, ..., threshold = 0.5, force = FALSE)
}
\arguments{
\item{x}{The estimated model to be evaluated.}

\item{...}{Unused. For future extensions.}

\item{threshold}{For \code{map_reliability}, the threshold applied to the
attribute-level probabilities for determining the binary attribute
classifications. Should be a numeric vector of length 1 (the same threshold
is applied to all attributes), or length equal to the number of attributes.
If a named vector is supplied, names should match the attribute names in the
Q-matrix used to estimate the model. If unnamed, thresholds should be in the
order the attributes were defined in the Q-matrix.}

\item{force}{If reliability information has already been added to the model
object with \code{\link[=add_reliability]{add_reliability()}}, should it be recalculated. Default is
\code{FALSE}.}
}
\value{
For class \code{measrdcm}, a list with 3 elements:
\itemize{
\item \code{pattern_reliability}: The pattern-level accuracy (\code{p_a}) and consistency
(\code{p_c}) described by Cui et al. (2012).
\item \code{map_reliability}: A list with 2 elements: \code{accuracy} and \code{consistency},
which include the attribute-level classification reliability statistics
described by Johnson & Sinharay (2018).
\item \code{eap_reliability}: The attribute-level posterior probability reliability
statistics described by Johnson & Sinharay (2020).
}
}
\description{
For diagnostic classification models, reliability can be estimated at the
pattern or attribute level. Pattern-level reliability represents the
classification consistency and accuracy of placing students into an overall
mastery profile. Rather than an overall profile, attributes can also be
scored individually. In this case, classification consistency and accuracy
should be evaluated for each individual attribute, rather than the overall
profile. This is referred to as the \emph{maximum a posteriori} (MAP) reliability.
Finally, it may be desirable to report results as the probability of
proficiency or mastery on each attribute instead of a proficient/not
proficient classification. In this case, the reliability of the posterior
probability should be reported. This is the \emph{expected a posteriori} (EAP)
reliability.
}
\details{
The pattern-level reliability (\code{pattern_reliability}) statistics are
described in Cui et al. (2012). Attribute-level classification reliability
statistics (\code{map_reliability}) are described in Johnson & Sinharay (2018).
Reliability statistics for the posterior mean of the skill indicators (i.e.,
the mastery or proficiency probabilities; \code{eap_reliability}) are described in
Johnson & Sinharay (2019).
}
\examples{
\dontshow{if (measr_examples()) withAutoprint(\{ # examplesIf}
rstn_mdm_lcdm <- dcm_estimate(
  dcm_specify(dcmdata::mdm_qmatrix, identifier = "item"),
  data = dcmdata::mdm_data,
  missing = NA,
  identifier = "respondent",
  method = "optim",
  seed = 63277,
  backend = "rstan"
)

reliability(rstn_mdm_lcdm)
\dontshow{\}) # examplesIf}
}
\references{
Cui, Y., Gierl, M. J., & Chang, H.-H. (2012). Estimating
classification consistency and accuracy for cognitive diagnostic
assessment. \emph{Journal of Educational Measurement, 49}(1), 19-38.
\doi{10.1111/j.1745-3984.2011.00158.x}

Johnson, M. S., & Sinharay, S. (2018). Measures of agreement to
assess attribute-level classification accuracy and consistency for
cognitive diagnostic assessments. \emph{Journal of Educational Measurement,
55}(4), 635-664. \doi{10.1111/jedm.12196}

Johnson, M. S., & Sinharay, S. (2020). The reliability of the
posterior probability of skill attainment in diagnostic classification
models. \emph{Journal of Educational and Behavioral Statistics, 45}(1), 5-31.
\doi{10.3102/1076998619864550}
}
