% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oplibrary.R
\name{arithmetic_crossover}
\alias{arithmetic_crossover}
\title{Performs arithmetic crossover operation on a pair of two selected parent candidate solutions}
\usage{
arithmetic_crossover(object, parents, ...)
}
\arguments{
\item{object}{A \code{GA::ga} object}

\item{parents}{Indices of the selected parents}

\item{...}{Additional arguments to be passed to the function}
}
\value{
List of two generated offspring
}
\description{
This function is not called directly but is given as a parameter in \code{GA::ga} function. 
In \code{GA::ga}, if the parameter \code{crossover=} is set to \code{arithmetic_crossover} than
the arithmetic crossover operator is applied in the genetic search. \code{arithmetic_crossover} generates offspring using the weighted mean of parents' genes. Weights are drawn randomly.
}
\examples{
f <- function(x){ 
  return(-sum( (x-5)^2 ) )
}
myga <- ga(type="real-valued", fitness = f, popSize = 100, maxiter = 100, 
           min = rep(-50,5), max = rep(50,5), crossover = arithmetic_crossover)
print(myga@solution)
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}

