/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.bool;

import choco.cp.solver.constraints.integer.DistanceXYZ;
import choco.cp.solver.constraints.reified.leaves.bool.AbstractBoolNode;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class DistNeqNode
extends AbstractBoolNode {
    public DistNeqNode(INode[] subt) {
        super(subt, NodeType.DISTNEQ);
    }

    @Override
    public SConstraint extractConstraint(Solver s) {
        IntDomainVar v1 = this.subtrees[0].extractResult(s);
        IntDomainVar v2 = this.subtrees[1].extractResult(s);
        IntDomainVar v3 = this.subtrees[2].extractResult(s);
        int a = v1.getInf() - v2.getInf();
        int b = v1.getInf() - v2.getSup();
        int c = v1.getSup() - v2.getInf();
        int d = v1.getSup() - v2.getSup();
        int lb = Math.min(Math.min(Math.min(a, b), c), d);
        int ub = Math.max(Math.max(Math.max(a, b), c), d);
        IntDomainVar v4 = lb == 0 && ub == 1 ? s.createBooleanVar(StringUtils.randomName()) : (v1.hasEnumeratedDomain() && v2.hasEnumeratedDomain() ? s.createEnumIntVar(StringUtils.randomName(), lb, ub) : s.createBoundIntVar(StringUtils.randomName(), lb, ub));
        s.post(new DistanceXYZ(v1, v2, v4, 0, 0));
        return s.neq((IntExp)v3, (IntExp)v4);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        return Math.abs(((ArithmNode)((Object)this.subtrees[0])).eval(tuple) - ((ArithmNode)((Object)this.subtrees[1])).eval(tuple)) != ((ArithmNode)((Object)this.subtrees[2])).eval(tuple);
    }

    @Override
    public boolean isDecompositionPossible() {
        return false;
    }

    @Override
    public String pretty() {
        return "(|" + this.subtrees[0].pretty() + "-" + this.subtrees[1].pretty() + "|!=" + this.subtrees[2].pretty() + ")";
    }
}

