% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{conn_fish}
\alias{conn_fish}
\title{Fisheye-Distorted Hospital–RACF Connections (\code{sf})}
\format{
An \code{\link[sf:sf]{sf}} object with:
\describe{
\item{weight}{Numeric, representing transfer magnitude or connection strength.}
\item{geometry}{\code{LINESTRING} geometries in projected CRS (EPSG:3111).}
}
}
\source{
Prepared in \code{data-raw/gen-data.R} from
\code{transfers_coded.csv} and the \code{make_connections()} function.
}
\usage{
conn_fish
}
\description{
An example \code{LINESTRING} layer showing hospital–RACF transfer routes
after applying a \strong{Focus–Glue–Context (FGC) fisheye warp}.
It demonstrates how line geometries can be spatially distorted in sync
with polygon layers to visualize flow patterns within the magnified focus zone.
}
\details{
Built from hospital–RACF coordinate pairs in \code{data-raw/transfers_coded.csv}
using:
\enumerate{
\item connection creation via \code{make_connections()} to form \code{LINESTRING}s,
\item projection to VicGrid94 (\code{EPSG:3111}),
\item distance-based filtering to keep only sources within \code{r_in = 0.34}
of the focus point (\code{cx = 145.0}, \code{cy = -37.8}),
\item fisheye transformation using \code{\link[=sf_fisheye]{sf_fisheye()}}
with \code{r_in = 0.428}, \code{r_out = 0.429}, and \code{zoom_factor = 1}.
}
The resulting object aligns spatially with \code{vic_fish}, allowing
co-visualization of regional flow intensity within the distorted focus region.
}
\examples{
library(sf)
plot(st_geometry(vic_fish), col = "grey95", border = "grey70")
plot(st_geometry(conn_fish), add = TRUE, col = "black", lwd = 1)
}
\seealso{
\code{\link[=sf_fisheye]{sf_fisheye()}}, \code{\link{vic_fish}}
}
\keyword{datasets}
