% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{html_format}
\alias{html_format}
\alias{latex_format}
\title{Output formats in YAML metadata}
\usage{
html_format(options = NULL, meta = NULL, template = NULL, keep_md = FALSE)

latex_format(
  options = NULL,
  meta = NULL,
  template = NULL,
  keep_md = FALSE,
  keep_tex = FALSE,
  latex_engine = "xelatex",
  citation_package = "natbib"
)
}
\arguments{
\item{meta, options}{Arguments to be passed to \code{\link[=mark]{mark()}}.}

\item{template}{A template file path.}

\item{keep_md, keep_tex}{Whether to keep the intermediate \file{.md} and
\file{.tex} files generated from \file{.Rmd}.}

\item{latex_engine}{The LaTeX engine to compile \file{.tex} to \file{.pdf}.}

\item{citation_package}{The LaTeX package for processing citations. Possible
values are \code{none}, \code{natbib}, and \code{biblatex}.}
}
\description{
These functions exist only for historical reasons, and should never be called
directly. They can be used to configure output formats in YAML, but you are
recommended to use the file format names instead of these function names.
}
\details{
To configure output formats in the YAML metadata of the Markdown document,
simply use the output format names such as \code{html} or \code{latex} in the \code{output}
field in YAML, e.g.,

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{---
output:
  html:
    options:
      toc: true
    keep_md: true
  latex:
    latex_engine: pdflatex
---
}\if{html}{\out{</div>}}

You can also use \code{litedown::html_format} instead of \code{html} (or
\code{litedown::latex_format} instead of \code{latex}) if you like.
}
\note{
If you want to use the \code{Knit} button in RStudio, you must add a
top-level field \code{knit: litedown:::knit} to the YAML metadata. See
\url{https://yihui.org/litedown/#sec:knit-button} for more information.
}
