% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lime-package.r
\docType{package}
\name{lime-package}
\alias{lime-package}
\title{lime: Local Interpretable Model-Agnostic Explanations}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

When building complex models, it is often difficult to explain why the model should be trusted. While global measures such as accuracy are useful, they cannot be used for explaining why a model made a specific prediction. 'lime' (a port of the 'lime' 'Python' package) is a method for explaining the outcome of black box models by fitting a local model around the point in question an perturbations of this point. The approach is described in more detail in the article by Ribeiro et al. (2016) \doi{10.48550/arXiv.1602.04938}.
}
\details{
This package is a port of the original Python lime package implementing the
prediction explanation framework laid out Ribeiro \emph{et al.} (2016). The
package supports models from \code{caret} and \code{mlr} natively, but see
\link[=model_support]{the docs} for how to make it work for any model.

\strong{Main functions:}

Use of \code{lime} is mainly through two functions. First you create an
\code{explainer} object using the \code{\link[=lime]{lime()}} function based on the training data and
the model, and then you can use the \code{\link[=explain]{explain()}} function along with new data
and the explainer to create explanations for the model output.

Along with these two functions, \code{lime} also provides the \code{\link[=plot_features]{plot_features()}}
and \code{\link[=plot_text_explanations]{plot_text_explanations()}} function to visualise the explanations
directly.
}
\references{
Ribeiro, M.T., Singh, S., Guestrin, C. \emph{"Why Should I Trust You?": Explaining the Predictions of Any Classifier}. 2016, \url{https://arxiv.org/abs/1602.04938}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://lime.data-imaginist.com}
  \item \url{https://github.com/tidymodels/lime}
  \item \url{https://lime.data-imaginist.com/}
  \item Report bugs at \url{https://github.com/tidymodels/lime/issues}
}

}
\author{
\strong{Maintainer}: Emil Hvitfeldt \email{emil.hvitfeldt@posit.co} (\href{https://orcid.org/0000-0002-0679-1945}{ORCID})

Authors:
\itemize{
  \item Thomas Lin Pedersen \email{thomasp85@gmail.com} (\href{https://orcid.org/0000-0002-5147-4711}{ORCID})
  \item Michaël Benesty \email{michael@benesty.fr}
}

}
\keyword{internal}
