% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_chm.R
\name{pitfill_stonge2008}
\alias{pitfill_stonge2008}
\title{Pits and spikes filling}
\usage{
pitfill_stonge2008(
  x,
  lap_size = 3L,
  thr_lap = 0.1,
  thr_spk = -0.1,
  med_size = 3L,
  dil_radius = 0L
)
}
\arguments{
\item{x}{raster. SpatRaster, RasterLayer, stars.}

\item{lap_size}{integer. Size of the Laplacian filter kernel (integer value, in pixels).}

\item{thr_lap}{numeric. Threshold Laplacian value for detecting a cavity (all values above this
value will be considered a cavity). A positive value.}

\item{thr_spk}{numeric. Threshold Laplacian value for detecting a spike (all values below this
value will be considered a spike). A negative value.}

\item{med_size}{integer. Size of the median filter kernel (integer value, in pixels).}

\item{dil_radius}{integer. Dilation radius (integer value, in pixels).}
}
\description{
Pits and spikes filling for raster. Typically used for post-processing CHM. This algorithm
is from St-Onge 2008 (see reference).
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile)
chm <- rasterize_canopy(las, 0.5, dsmtin())
sto <- pitfill_stonge2008(chm)

#terra::plot(c(chm, sto), col = lidR::height.colors(25))
}
\references{
St-Onge, B., 2008. Methods for improving the quality of a true orthomosaic of Vexcel UltraCam
images created using alidar digital surface model, Proceedings of the Silvilaser 2008, Edinburgh,
555-562. https://citeseerx.ist.psu.edu/document?repid=rep1&type=pdf&doi=81365288221f3ac34b51a82e2cfed8d58defb10e
}
