% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{residuals.lcc}
\alias{residuals.lcc}
\title{Extract Residuals from a Fitted lcc Model}
\usage{
\method{residuals}{lcc}(object, type = "response", ...)
}
\arguments{
\item{object}{An object of class \code{lcc}, representing a fitted 
longitudinal concordance correlation function.}

\item{type}{A character string specifying the type of residuals to extract.
Options are \code{"response"} for residuals obtained by subtracting
the fitted values from the response (default), \code{"pearson"} for
"response" residuals divided by the estimated within-group standard error,
and \code{"normalized"} for normalized residuals. Partial matching is
used, so only the first character of the type is necessary.}

\item{...}{Optional arguments passed to the \code{residuals.lme}
function from the \code{nlme} package.}
}
\description{
Extracts residuals from the fitted longitudinal concordance correlation
model represented by an \code{lcc} object. Different types of residuals can
be obtained based on the specified type.
}
\details{
The function provides a convenient way to examine the differences between
observed and predicted values in the model. Understanding these residuals
can be crucial for model diagnostics and validation. For more information,
refer to the methods for \code{\link[nlme]{nlme}} objects.
}
\examples{
\dontrun{
fm1 <- lcc(data = hue, subject = "Fruit", resp = "H_mean",
           method = "Method", time = "Time", qf = 2, qr = 2)
residuals(fm1)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{summary.lcc}},
  \code{\link{coef.lcc}}, \code{\link{vcov.lcc}}
}
