% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mgamma}
\alias{mgamma}
\title{Multivariate gamma function}
\usage{
mgamma(x, p, log = FALSE)
}
\arguments{
\item{x}{[vector] of points at which to evaluate the function}

\item{p}{[int] dimension of the multivariate gamma function, strictly positive.}

\item{log}{[logical] if \code{TRUE}, returns the log multivariate gamma function.}
}
\value{
a matrix with one column of the same length as \code{x}
}
\description{
Given a vector of points \code{x} and an order \code{p}, compute the multivariate gamma function. The function is defined as
\deqn{\gamma_p(x) = \pi^{p(p-1)/4}\prod_{i=1}^p \Gamma\{x + (1-i)/2\}.}
}
