% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{deserialize_keras_object}
\alias{deserialize_keras_object}
\title{Retrieve the object by deserializing the config dict.}
\usage{
deserialize_keras_object(config, custom_objects = NULL, safe_mode = TRUE, ...)
}
\arguments{
\item{config}{Named list describing the object.}

\item{custom_objects}{Named list containing a mapping between custom
object names the corresponding classes or functions.}

\item{safe_mode}{Boolean, whether to disallow unsafe \code{lambda} deserialization.
When \code{safe_mode=FALSE}, loading an object has the potential to
trigger arbitrary code execution. This argument is only
applicable to the Keras v3 model format. Defaults to \code{TRUE}.}

\item{...}{For forward/backward compatability.}
}
\value{
The object described by the \code{config} dictionary.
}
\description{
The config dict is a Python dictionary that consists of a set of key-value
pairs, and represents a Keras object, such as an \code{Optimizer}, \code{Layer},
\code{Metrics}, etc. The saving and loading library uses the following keys to
record information of a Keras object:
\itemize{
\item \code{class_name}: String. This is the name of the class,
as exactly defined in the source
code, such as "LossesContainer".
\item \code{config}: Named List. Library-defined or user-defined key-value pairs that store
the configuration of the object, as obtained by \code{object$get_config()}.
\item \code{module}: String. The path of the python module. Built-in Keras classes
expect to have prefix \code{keras}.
\item \code{registered_name}: String. The key the class is registered under via
\code{register_keras_serializable(package, name)} API. The
key has the format of \code{'{package}>{name}'}, where \code{package} and \code{name} are
the arguments passed to \code{register_keras_serializable()}. If \code{name} is not
provided, it uses the class name. If \code{registered_name} successfully
resolves to a class (that was registered), the \code{class_name} and \code{config}
values in the config dict will not be used. \code{registered_name} is only used for
non-built-in classes.
}

For example, the following config list represents the built-in Adam optimizer
with the relevant config:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{config <- list(
  class_name = "Adam",
  config = list(
    amsgrad = FALSE,
    beta_1 = 0.8999999761581421,
    beta_2 = 0.9990000128746033,
    epsilon = 1e-07,
    learning_rate = 0.0010000000474974513,
    name = "Adam"
  ),
  module = "keras.optimizers",
  registered_name = NULL
)
# Returns an `Adam` instance identical to the original one.
deserialize_keras_object(config)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## <keras.src.optimizers.adam.Adam object at 0x0>

}\if{html}{\out{</div>}}

If the class does not have an exported Keras namespace, the library tracks
it by its \code{module} and \code{class_name}. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{config <- list(
  class_name = "MetricsList",
  config =  list(
    ...
  ),
  module = "keras.trainers.compile_utils",
  registered_name = "MetricsList"
)

# Returns a `MetricsList` instance identical to the original one.
deserialize_keras_object(config)
}\if{html}{\out{</div>}}

And the following config represents a user-customized \code{MeanSquaredError}
loss:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# define a custom object
loss_modified_mse <- Loss(
  "ModifiedMeanSquaredError",
  inherit = loss_mean_squared_error)

# register the custom object
register_keras_serializable(loss_modified_mse)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## function (reduction = "sum_over_batch_size", name = "mean_squared_error",
##     dtype = NULL)
## \{
##     args <- capture_args(enforce_all_dots_named = FALSE)
##     do.call(ModifiedMeanSquaredError, args)
## \}
## <environment: 0x64adddcab880>

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# confirm object is registered
get_custom_objects()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## $`keras3>ModifiedMeanSquaredError`
## <class '<r-namespace:keras3>.ModifiedMeanSquaredError'>
##  signature: (
##    reduction='sum_over_batch_size',
##    name='mean_squared_error',
##    dtype=None
## )

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{get_registered_name(loss_modified_mse)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "keras3>ModifiedMeanSquaredError"

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# now custom object instances can be serialized
full_config <- serialize_keras_object(loss_modified_mse())

# the `config` arguments will be passed to loss_modified_mse()
str(full_config)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## List of 4
##  $ module         : chr "<r-namespace:keras3>"
##  $ class_name     : chr "ModifiedMeanSquaredError"
##  $ config         :List of 2
##   ..$ name     : chr "mean_squared_error"
##   ..$ reduction: chr "sum_over_batch_size"
##  $ registered_name: chr "keras3>ModifiedMeanSquaredError"

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# and custom object instances can be deserialized
deserialize_keras_object(full_config)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## <LossFunctionWrapper(<function mean_squared_error at 0x0>, kwargs=\{\})>
##  signature: (y_true, y_pred, sample_weight=None)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Returns the `ModifiedMeanSquaredError` object
}\if{html}{\out{</div>}}
}
\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_saving_apis/serialization_utils#deserializekerasobject-function}
}

Other serialization utilities: \cr
\code{\link{get_custom_objects}()} \cr
\code{\link{get_registered_name}()} \cr
\code{\link{get_registered_object}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{serialize_keras_object}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{serialization utilities}
