% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\name{Model}
\alias{Model}
\title{Subclass the base Keras \code{Model} Class}
\usage{
Model(
  classname,
  initialize = NULL,
  call = NULL,
  train_step = NULL,
  predict_step = NULL,
  test_step = NULL,
  compute_loss = NULL,
  compute_metrics = NULL,
  ...,
  public = list(),
  private = list(),
  inherit = NULL,
  parent_env = parent.frame()
)
}
\arguments{
\item{classname}{String, the name of the custom class. (Conventionally, CamelCase).}

\item{initialize, call, train_step, predict_step, test_step, compute_loss, compute_metrics}{Optional methods that can be overridden.}

\item{..., public}{Additional methods or public members of the custom class.}

\item{private}{Named list of R objects (typically, functions) to include in
instance private environments. \code{private} methods will have all the same
symbols in scope as public methods (See section "Symbols in Scope"). Each
instance will have it's own \code{private} environment. Any objects
in \code{private} will be invisible from the Keras framework and the Python
runtime.}

\item{inherit}{What the custom class will subclass. By default, the base keras class.}

\item{parent_env}{The R environment that all class methods will have as a grandparent.}
}
\value{
A model constructor function, which you can call to create an
instance of the new model type.
}
\description{
This is for advanced use cases where you need to subclass the base \code{Model}
type, e.g., you want to override the \code{train_step()} method.

If you just want to create or define a keras model, prefer \code{\link[=keras_model]{keras_model()}}
or \code{\link[=keras_model_sequential]{keras_model_sequential()}}.

If you just want to encapsulate some custom logic and state, and don't need
to customize training behavior (besides calling \code{self$add_loss()} in the
\code{call()} method), prefer \code{\link[=Layer]{Layer()}}.
}
\section{Symbols in scope}{
All R function custom methods (public and private) will have the
following symbols in scope:
\itemize{
\item \code{self}: The custom class instance.
\item \code{super}: The custom class superclass.
\item \code{private}: An R environment specific to the class instance.
Any objects assigned here are invisible to the Keras framework.
\item \verb{__class__} and \code{as.symbol(classname)}: the custom class type object.
}
}

\seealso{
\code{\link[=active_property]{active_property()}} (e.g., for a \code{metrics} property implemented as a
function).
}
