utils::globalVariables(c(".", ":=", "%>%"))

#' @importFrom dplyr %>%
#' @export
dplyr::`%>%`


GoogleAuth <- function() {
  
  googlesheets4::gs4_auth(email = TRUE)
  
}


RenewAuth <- function() {
  
  googlesheets4::gs4_token()
  
}


yupana_full <- function() {
  
  inti::yupana(dependencies = TRUE)
  
}


tarpuy_full <- function() {
  
  inti::tarpuy(dependencies = TRUE)
  
}

anova_table <- function(model, digits = 4) {
  
  df <- as.data.frame(model) %>%
    tibble::rownames_to_column("Factor")
  
  # Detectar nombre de la columna de p-valor
  p_col <- dplyr::case_when(
    "Pr(>F)" %in% names(df)      ~ "Pr(>F)",
    "Pr(>Chisq)" %in% names(df)  ~ "Pr(>Chisq)",
    TRUE ~ NA_character_
  )
  
  if (is.na(p_col)) stop("No p-value column found: expected 'Pr(>F)' or 'Pr(>Chisq)'.")
  
  # Formato de p-valores: notación científica si son muy pequeños
  df[[p_col]] <- ifelse(
    df[[p_col]] < 0.0001,
    formatC(df[[p_col]], format = "e", digits = digits),
    formatC(df[[p_col]], format = "f", digits = digits)
  )
  
  # Añadir columna de significancia
  df <- df %>%
    dplyr::mutate(
      Sig = dplyr::case_when(
        as.numeric(.data[[p_col]]) <= 0.001 ~ "***",
        as.numeric(.data[[p_col]]) <= 0.01  ~ "**",
        as.numeric(.data[[p_col]]) <= 0.05  ~ "*",
        TRUE ~ "ns"
      )
    )
  
  # Convertir columnas a texto
  df <- df %>% dplyr::mutate(across(everything(), as.character))
  
  # Agregar leyenda
  df <- df %>%
    tibble::add_row(Factor = "---") %>%
    tibble::add_row(
      Factor = "Significance:",
      !!names(df)[2] := "0.001 ***",
      !!names(df)[3] := "0.01 **",
      !!p_col := "0.05 *"
    )
  
  return(df)
}

yesno <- function(msg, .envir = parent.frame()) {
  si <- c("Yes", "Definitely", "For sure", "Yup", "Yeah", 
          "Of course", "Absolutely")
  no <- c("No way", "Not yet", "I forget", "No", "Nope", 
          "Uhhhh... Maybe?")
  cli::cli_inform(msg, .envir = .envir)
  qs <- c(sample(si, 1), sample(no, 2))
  rand <- sample(length(qs))
  return(utils::menu(qs[rand]) == which(rand == 1))
}

scihub <- function() {
  # Define the source directory inside the package
  src_dir <- system.file("extdata/_extensions/scihub", package = "inti")
  
  if (src_dir == "") {
    stop("The 'scihub' folder was not found")
  }
  
  # Ask user for confirmation
  message("Files from 'scihub' will be copied to the current working directory:\n", 
          getwd(), "\n")
  
  confirm <- yesno("Do you want to continue?")
  
  if (isTRUE(confirm)) {
    # List files to copy
    files <- list.files(src_dir, full.names = TRUE)
    
    # Copy files to the working directory
    file.copy(files, to = getwd(), overwrite = FALSE, recursive = TRUE)
    
    message("Files were successfully copied.")
  } else {
    message("Operation cancelled by the user.")
  }
}

paleta <- function() {
  
  # paleta <- function() {
  #   list(RColorBrewer::brewer.pal(8, "Set2"), 
  #        RColorBrewer::brewer.pal(8, "Pastel1")) |>
  #     unlist()
  #   }
  
  c("#66C2A5", "#FC8D62", "#8DA0CB", "#E78AC3"
    , "#A6D854", "#FFD92F", "#E5C494", "#B3B3B3"
    , "#FBB4AE", "#B3CDE3", "#CCEBC5", "#DECBE4"
    , "#FED9A6", "#FFFFCC", "#E5D8BD", "#FDDAEC")

}
  
  
  

