suppressWarnings(skip_if_not_installed("glmmTMB"))
skip_if_not_installed("biglm")

data(Salamanders, package = "glmmTMB")
Salamanders$cover <- abs(Salamanders$cover)

m1 <- biglm::bigglm(
  count ~ mined + log(cover) + sample,
  family = poisson(),
  data = Salamanders
)

test_that("model_info", {
  expect_true(model_info(m1)$is_poisson)
  expect_true(model_info(m1)$is_count)
  expect_false(model_info(m1)$is_negbin)
  expect_false(model_info(m1)$is_binomial)
  expect_false(model_info(m1)$is_linear)
})

test_that("find_predictors", {
  expect_identical(find_predictors(m1), list(conditional = c("mined", "cover", "sample")))
  expect_identical(
    find_predictors(m1, flatten = TRUE),
    c("mined", "cover", "sample")
  )
  expect_null(find_predictors(m1, effects = "random"))
})

test_that("find_random", {
  expect_null(find_random(m1))
})

test_that("get_random", {
  expect_warning(get_random(m1))
})

test_that("get_varcov", {
  expect_equal(vcov(m1), get_varcov(m1), tolerance = 1e-3)
})

test_that("find_response", {
  expect_identical(find_response(m1), "count")
})

test_that("get_response", {
  expect_identical(get_response(m1), Salamanders$count)
})

test_that("get_predictors", {
  expect_named(get_predictors(m1), c("mined", "cover", "sample"))
})

test_that("link_inverse", {
  expect_equal(link_inverse(m1)(0.2), exp(0.2), tolerance = 1e-5)
})

test_that("get_data", {
  expect_identical(nrow(get_data(m1)), 644L)
  expect_named(get_data(m1), c("count", "mined", "cover", "sample"))
})

test_that("find_formula", {
  expect_length(find_formula(m1), 1)
  expect_equal(
    find_formula(m1),
    list(conditional = as.formula("count ~ mined + log(cover) + sample")),
    ignore_attr = TRUE
  )
})

test_that("find_variables", {
  expect_identical(
    find_variables(m1),
    list(
      response = "count",
      conditional = c("mined", "cover", "sample")
    )
  )
  expect_identical(
    find_variables(m1, flatten = TRUE),
    c("count", "mined", "cover", "sample")
  )
})

test_that("n_obs", {
  expect_identical(n_obs(m1), 644)
})

test_that("linkfun", {
  expect_false(is.null(link_function(m1)))
})

test_that("find_parameters", {
  expect_identical(
    find_parameters(m1),
    list(
      conditional = c("(Intercept)", "minedno", "log(cover)", "sample")
    )
  )
  expect_identical(nrow(get_parameters(m1)), 4L)
  expect_identical(
    get_parameters(m1)$Parameter,
    c("(Intercept)", "minedno", "log(cover)", "sample")
  )
})

test_that("is_multivariate", {
  expect_false(is_multivariate(m1))
})

test_that("find_terms", {
  expect_identical(
    find_terms(m1),
    list(
      response = "count",
      conditional = c("mined", "log(cover)", "sample")
    )
  )
})

test_that("find_algorithm", {
  expect_identical(find_algorithm(m1), list(algorithm = "ML"))
})

test_that("find_statistic", {
  expect_identical(find_statistic(m1), "z-statistic")
})
