% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surd.R
\name{surd}
\alias{surd}
\alias{surd,data.frame-method}
\alias{surd,sf-method}
\alias{surd,SpatRaster-method}
\title{synergistic-unique-redundant decomposition of causality}
\usage{
\S4method{surd}{data.frame}(
  data,
  target,
  agents,
  lag = 1,
  bin = 5,
  max.combs = NULL,
  cores = 1,
  backend = "threading"
)

\S4method{surd}{sf}(
  data,
  target,
  agents,
  lag = 1,
  bin = 5,
  max.combs = NULL,
  cores = 1,
  backend = "threading",
  nb = NULL
)

\S4method{surd}{SpatRaster}(
  data,
  target,
  agents,
  lag = 1,
  bin = 5,
  max.combs = NULL,
  cores = 1,
  backend = "threading"
)
}
\arguments{
\item{data}{observation data.}

\item{target}{name of the target variable.}

\item{agents}{names of agent variables.}

\item{lag}{(optional) lag order.}

\item{bin}{(optional) number of discretization bins.}

\item{max.combs}{(optional) maximum combination order. If \code{NULL}, the standard SURD decomposition is applied.}

\item{cores}{(optional) number of cores for parallel computation.}

\item{backend}{(optional) \code{Joblib} backend: \code{loky}, \code{threading}, or \code{multiprocessing}.}

\item{nb}{(optional) neighbours list.}
}
\value{
A list.
\describe{
\item{unique}{Unique information contributions per variable.}
\item{synergistic}{Synergistic information components by agent combinations.}
\item{redundant}{Redundant information shared by agent subsets.}
\item{mutual_info}{Mutual information measures for each combination.}
\item{info_leak}{Information leak ratio.}
}
}
\description{
synergistic-unique-redundant decomposition of causality
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
tryCatch(
  surd(columbus, "hoval", c("inc", "crime")),
  error = \(e) message("Skipping Python-dependent example: ", e$message)
)
}
}
\references{
Martinez-Sanchez, A., Arranz, G. & Lozano-Duran, A. Decomposing causality into its synergistic, unique, and redundant components. Nat Commun 15, 9296 (2024).
}
