% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EdgerDEG.R
\name{EdgerDEG}
\alias{EdgerDEG}
\title{EdgerDEG}
\usage{
EdgerDEG(
  gr,
  WD_samples,
  WD_DEGs,
  colIDgene,
  colCounts,
  skip_preN,
  grContrast,
  filter,
  model,
  normMethod,
  min_count,
  min_total_count,
  large_n,
  min_prop,
  adjustPvalue,
  Th_logFC,
  Th_Pvalue
)
}
\arguments{
\item{gr}{Data frame. Sample metadata with columns Samples and Groups.}

\item{WD_samples}{Character. Directory containing raw count .tab files.}

\item{WD_DEGs}{Character. Directory in which to write results and logs.}

\item{colIDgene}{Integer. Column index in each count file for gene IDs.}

\item{colCounts}{Integer. Column index in each count file for raw counts.}

\item{skip_preN}{Integer. Number of header lines to skip when reading count files.}

\item{grContrast}{Data frame. Two-column table with Test and Baseline group names for contrasts.}

\item{filter}{Character. Filtering method: "filterByExpr" or "HTSFilter".}

\item{model}{Character. Statistical test: "exactTest", "glmQLFTest", or "glmLRT".}

\item{normMethod}{Character. Normalization method for edgeR (e.g., "TMM", "RLE").}

\item{min_count}{Numeric. Minimum count per gene for "filterByExpr".}

\item{min_total_count}{Numeric. Minimum total count per gene for "filterByExpr".}

\item{large_n}{Integer. Sample size threshold for "filterByExpr".}

\item{min_prop}{Numeric. Proportion threshold for "filterByExpr".}

\item{adjustPvalue}{Character. P-value adjustment method (e.g., "fdr", "holm", "none").}

\item{Th_logFC}{Numeric. Absolute log-fold-change threshold to call differential expression.}

\item{Th_Pvalue}{Numeric. Adjusted p-value threshold to call differential expression.}
}
\value{
A list invisibly returned containing any captured plots and log messages;
primary results are written to CSV files in "WD_DEGs".
}
\description{
Perform differential expression analysis on RNA-seq count data using edgeR.
}
\details{
This function reads raw count tables, applies expression filtering (via "filterByExpr" or "HTSFilter"),
normalizes library sizes, estimates dispersion, fits statistical models ("exactTest", "glmQLFTest", or "glmLRT"),
and writes per-contrast results and diagnostic plots.
\enumerate{
\item Reads in per-sample count files and generate a DGEList.
\item Builds the design matrix and contrast definitions from "grContrast".
\item Filters lowly expressed genes, normalizes library sizes, and logs filtering summary.
\item Estimates dispersion (standard or quasi-likelihood).
\item Runs chosen differential test per contrast, annotates each gene as "UP", "DOWN", or "NO",
and writes CSV output files named by filter, model, and contrast.
\item Captures and saves BCV and QL dispersion plots as SVGs in WD_DEGs.
}
}
