% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseflowA.R
\name{baseflowA}
\alias{baseflowA}
\title{Baseflow removal (after Fuka et al. 2018)}
\usage{
baseflowA(q, alpha = 0.925, passes = 3)
}
\arguments{
\item{q}{The vector series of streamflow}

\item{alpha}{Filter parameter}

\item{passes}{Number of passes}
}
\value{
A list of the baseflow and baseflow index at each timestep.
}
\description{
This function calculates baseflow using a recursive digital filter and is based on
the implementation in the EcoHydRology package.

The formulation is originally after Lyne and Hollick (1979) and described in Furey and Gupta (2001).
Recommended parameters are after Nathan and McMahon (1990).
}
\examples{
library(hydroEvents)
data(dataBassRiver)
alpha.list = c(0, 0.9, 0.925, 0.95, 0.98, 0.987)
BFI.1 = numeric(length(alpha.list))
for (i in 1:length(alpha.list)) {
  bf.1 = baseflowA(dataBassRiver, alpha = alpha.list[i])
  BFI.1[i] = sum(bf.1$bf)/sum(dataBassRiver)
}
print(cbind(alpha.list, BFI.1))
}
\references{
Fuka D. R., Walter, M.T., Archiblad, J.A., Steenhuis, T.S., & Easton, Z. M. (2018).
A Community Modeling Foundation for Eco-Hydrology, R package version 0.4.12.1
Flow from Streamflow Time Series. Water Resources Research, 37(11), 2709–2722.

Furey, P., & Gupta, V. (2001). A Physically Based Filter for Spearating Base
Flow from Streamflow Time Series. Water Resources Research, 37(11), 2709–2722.

Lyne, V., & Hollick, M. (1979). Stochastic time-variable rainfall-runoff modelling.
Institute of Engineers Australia National Conference, 89-92.

Nathan, R. J., & McMahon, T. A. (1990). Evaluation of automated techniques for base flow and recession analyses.
Water Resources Research, 26(7), 1465–1473.
}
\keyword{baseflow}
