% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-url.R
\name{is_github_url}
\alias{is_github_url}
\title{Detect a URL on github.com}
\usage{
is_github_url(url)
}
\arguments{
\item{url}{character string of the URL to check.}
}
\value{
Logical. \code{TRUE} if the URL on \code{github.com}, \code{FALSE} otherwise.
}
\description{
Detect a URL on github.com
}
\examples{
# Returns TRUE
is_github_url("https://github.com/hubverse-org/example-simple-forecast-hub")
is_github_url("https://github.com/hubverse-org/schemas/tree/main/v5.0.0")
# Returns FALSE
is_github_url("https://gitlab.com/hubverse-org/schemas/tree/main/v5.0.0")
raw_url <- paste0(
  "https://raw.githubusercontent.com/hubverse-org/",
  "example-simple-forecast-hub/refs/heads/main/hub-config/tasks.json"
)
is_github_url(raw_url)
}
