% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_pfas1comp.R
\name{parameterize_pfas1comp}
\alias{parameterize_pfas1comp}
\title{Parameters for a one compartment (empirical) toxicokinetic model for PFAS}
\usage{
parameterize_pfas1comp(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  sex = "Female",
  dosingadj = "Oral",
  restrict.doa = "ClassModDomain",
  estimate.firstpass = TRUE,
  suppress.messages = FALSE,
  Caco2.options = list(),
  class.exclude = TRUE,
  physchem.exclude = TRUE
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{sex}{Sex of simulated individual ("Male" or "Female")}

\item{dosingadj}{Route of dosing for Dawson et al. (2023) PFAS half-life model
("oral", "iv", or "other")}

\item{restrict.doa}{Whether to restrict to chemicals within an estimated
domain of applicability based on the properties of the training set
("ClassModDomain"), the domain of all models ("AMAD"), or none ("none")
(Defaults to "ClassModDomain").}

\item{estimate.firstpass}{Whether to estimate first-pass hepatic metabolism,
which can only be done for a subset of PFAS with in vitro HTTK parameters
(Defaults to TRUE).}

\item{suppress.messages}{Whether to suppress messages (Defaults to FALSE).}

\item{Caco2.options}{A list of options to use when working with Caco2 apical 
to basolateral data \code{Caco2.Pab}, default is Caco2.options = 
list(Caco2.Pab.default = 1.6, Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, 
overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.Pab.default sets the 
default value for Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE 
uses Caco2.Pab to calculate fabs.oral, otherwise fabs.oral = \code{Fabs}. 
Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE 
overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut 
with 1 (i.e. 100 percent) regardless of other settings.
See \code{\link{get_fbio}} for further details.}

\item{class.exclude}{Exclude chemical classes identified as outside of 
domain of applicability by relevant modelinfo_[MODEL] file (default TRUE).}

\item{physchem.exclude}{Exclude chemicals on the basis of physico-chemical
properties (currently only Henry's law constant) as specified by 
the relevant modelinfo_[MODEL] file (default TRUE).}
}
\value{
\item{Vdist}{Volume of distribution, units of L/kg BW.}
\item{plasma.vol}{Volume of the plasma, L/kg BW.}
\item{Fabsgut}{Fraction of the oral dose absorbed, that is, the fraction of the
dose that enters the gutlumen.} 
\item{Fhep.assay.correction}{Not used for this model} 
\item{kelim}{Elimination rate, units of 1/h.} 
\item{hematocrit}{Percent volume of red blood cells in the blood.}
\item{kgutabs}{Rate chemical is absorbed, 1/h.}
\item{million.cells.per.gliver}{Not used for this model}
\item{MW}{Molecular Weight, g/mol.} 
\item{Rblood2plasma}{The ratio of the concentration of the chemical in the 
blood to the concentration in the plasma. Not used in calculations but 
included for the conversion of plasma outputs.} 
\item{hepatic.bioavailability}{Fraction of dose remaining after
first pass clearance, calculated from the corrected well-stirred model.}
\item{BW}{Body Weight, kg.}
\item{pKa_Donor}{Ionization equilibria (if any) for hydrogen donation (acids).} 
\item{pKa_Accept}{Ionization equilibria (if any) for hydrogen acceptance (bases).}
}
\description{
This function initializes the parameters needed in the function solve_1comp.
The toxicokinetic model is of the form of an
empirical, single compartment in which all tissues are well mixed. 
The route of exposure can be oral or intravenous. 
For oral exposures a hepatic extraction factor (first-pass 
metabolism) is estimated using
chemical-specific \emph{in vitro}-measured intrinsic hepatic 
clearance and fraction
unbound in plasma, if available. If these chemical-specific parameters are 
not available then all chemical is assumed to be absorbed. 
The rate of oral absorption used
is 2.2 L/h, the median rate observed across 44 chemicals by 
Wambaugh et al. (2018) (\doi{10.1093/toxsci/kfy020}).
There is a single, unspecified route of elimination (clearance). 
Half-life is estimated using the 
Dawson et al. (2023) (\doi{10.3390/toxics11020098}) 
machine learning model for per- and poly-fluorinated alkyl substances (PFAS).
In keeping with the findings of that paper, volume of distribution is held 
fixed at 0.205 L kg/BW. Clearance is calculated as the product of elimination
rate (determined from half-life) and the volume of distribution.
The ratio of chemical concentration in blood to plasma is determined
according to
Poothong et al. (2017) (\doi{10.1021/acs.est.7b03299})
where compounds that are ionized at pH 7.4 (plasma) get a value of 0.5, while
chemicals that are neutral get a value of 20.
}
\examples{
# Human elimination rate for PFOA:
parameterize_pfas1comp(dtxsid="DTXSID8031865")$kelim
# Female rat is much faster than human:
parameterize_pfas1comp(dtxsid="DTXSID8031865", species="rat")$kelim
# Male rat is slower than female but faster than humans:
parameterize_pfas1comp(dtxsid="DTXSID8031865", species="rat", sex="male")$kelim

}
\references{
\insertRef{dawson2023machine}{httk}

\insertRef{pearce2017httk}{httk}

\insertRef{schmitt2008general}{httk}

\insertRef{pearce2017evaluation}{httk}

\insertRef{wambaugh2018evaluating}{httk}

\insertRef{poothong2017distribution}{httk}
}
\seealso{
\code{\link{solve_1comp}}

\code{\link{calc_analytic_css_1comp}}

\code{\link{calc_vdist}}

\code{\link{parameterize_steadystate}}

\code{\link{apply_clint_adjustment}}

\code{\link{tissue.data}}

\code{\link{physiology.data}}
}
\author{
John Wambaugh
}
\keyword{1compartment}
\keyword{PFAS}
\keyword{Parameter}
