% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_armitage.R
\name{parameterize_armitage}
\alias{parameterize_armitage}
\title{Parameterize Armitage In Vitro Distribution Model}
\usage{
parameterize_armitage(tcdata = NA, casrn.vector = NA_character_)
}
\arguments{
\item{tcdata}{A data.table with casrn, nomconc, MP, gkow, gkaw, gswat, sarea,
v_total, v_working. Otherwise supply single values to this.params (e.g., this.sarea,
this.v_total, etc.). Chemical parameters are taken from 
\code{\link{chem.physical_and_invitro.data}}.}

\item{casrn.vector}{A deprecated argument specifying a single or vector of 
Chemical Abstracts Service Registry 
Number(s) (CAS-RN) of desired chemical(s).}
}
\value{
\tabular{lll}{
\strong{Param} \tab \strong{Description} \tab \strong{Units} \cr
casrn \tab Chemical Abstracts Service Registry Number \tab character \cr
logHenry \tab The log10 Henry's law constant \tab atm*m^3/mol \cr      
MP_C \tab The chemical compound's melting point \tab degrees C \cr           
MW \tab The chemical compound's molecular weight \tab g/mol \cr          
gkow_n \tab The log10 octanol to water (PC) (logP)\tab log10 unitless ratio \cr  
pKa_Donor \tab Chemical dissociation equilibrium constant(s); pKa(ie pKa_Donor) = -log10(Ka) \tab unitless \cr  
pKa_Accept \tab Chemical association equilibrium constant(s); pKb(ie pKa_Accept) = 14 - pKa  \tab unitless \cr 
pH \tab pH where ionization is evaluated (typically assay medium) \tab unitless \cr 
gkaw_n \tab The air to water PC (neutral) \tab unitless ratio \cr
gswat_n \tab The log10 water solubility at 25C (logWSol) \tab log10 mg/L \cr
}
}
\description{
Parameterize Armitage In Vitro Distribution Model
}
\references{
\insertRef{armitage2014application}{httk}
}
\author{
Meredith Scherer
}
