/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Imodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5Ipkg.h"     

#ifndef H5_NO_DEPRECATED_SYMBOLS

H5I_type_t
H5Iregister_type1(size_t H5_ATTR_UNUSED hash_size, unsigned reserved, H5I_free_t free_func)
{
    H5I_type_t ret_value = H5I_BADID;

    FUNC_ENTER_API(H5I_BADID)

    if (H5I_BADID == (ret_value = H5I__register_type_common(reserved, free_func)))
        HGOTO_ERROR(H5E_ID, H5E_CANTINIT, H5I_BADID, "can't initialize ID class");

done:
    FUNC_LEAVE_API(ret_value)
} 
#endif 
